/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.inventory.bit;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.inventory.bit.SlottedBitInventory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SlottedBitInventoryItemStack
extends SlottedBitInventory
implements IBitInventoryItemStack {
    private final Function<CompoundTag, ItemStack> saveBuilder;

    public SlottedBitInventoryItemStack(int size, Function<CompoundTag, ItemStack> saveBuilder) {
        super(size);
        this.saveBuilder = saveBuilder;
    }

    @Override
    public ItemStack toItemStack() {
        CompoundTag compoundNBT = this.serializeNBT();
        return this.saveBuilder.apply(compoundNBT);
    }

    @Override
    public List<Component> listContents() {
        return this.getContents().stream().sorted(Comparator.comparingInt(SlottedBitInventory.BitSlot::getCount).reversed()).map(slot -> new TranslatableComponent("chiselsandbits.bitbag.contents.enum.entry", new Object[]{slot.getCount(), slot.getBlockInformation().getBlockState().m_60734_().m_49954_()})).collect(Collectors.toList());
    }

    @Override
    public double getFilledRatio() {
        return (double)this.slotMap.keySet().size() / (double)this.size;
    }

    @Override
    public void clear(BlockInformation state) {
        Int2ObjectArrayMap slots = new Int2ObjectArrayMap(this.slotMap);
        this.slotMap.clear();
        int slotIndex = 0;
        for (SlottedBitInventory.BitSlot bitSlot : slots.values()) {
            if (bitSlot.getBlockInformation() == state) continue;
            this.slotMap.put(slotIndex, (Object)bitSlot);
            ++slotIndex;
        }
    }

    @Override
    public void sort() {
        HashMap contentMap = Maps.newHashMap();
        this.slotMap.values().forEach(bitSlot -> {
            contentMap.putIfAbsent(bitSlot.getBlockInformation(), 0);
            contentMap.compute(bitSlot.getBlockInformation(), (s, c) -> (c == null ? 0 : c) + bitSlot.getCount());
        });
        this.slotMap.clear();
        ArrayList toSort = new ArrayList(contentMap.entrySet());
        toSort.sort(Map.Entry.comparingByValue().reversed());
        int slotIndex = 0;
        for (Map.Entry entry : toSort) {
            int count = (Integer)entry.getValue();
            if (count == 0) continue;
            while (count > IServerConfiguration.getInstance().getBagStackSize().get() && count > 0) {
                this.slotMap.put(slotIndex, (Object)new SlottedBitInventory.BitSlot((BlockInformation)entry.getKey(), IServerConfiguration.getInstance().getBagStackSize().get()));
                ++slotIndex;
                count -= IServerConfiguration.getInstance().getBagStackSize().get().intValue();
            }
            if (count <= 0) continue;
            this.slotMap.put(slotIndex, (Object)new SlottedBitInventory.BitSlot((BlockInformation)entry.getKey(), count));
            ++slotIndex;
        }
    }

    public int m_6643_() {
        return this.size;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return super.getItem(index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        if (!this.slotMap.containsKey(index)) {
            return ItemStack.f_41583_;
        }
        SlottedBitInventory.BitSlot bitSlot = (SlottedBitInventory.BitSlot)this.slotMap.get(index);
        int containedCount = bitSlot.getCount();
        bitSlot.setCount(containedCount - count);
        if (bitSlot.getCount() <= 0) {
            this.slotMap.remove(index);
        }
        return IBitItemManager.getInstance().create(bitSlot.getBlockInformation(), Math.min(containedCount, count));
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return this.m_7407_(index, Integer.MAX_VALUE);
    }

    public void m_6836_(int index, ItemStack stack) {
        if (stack.m_41619_()) {
            this.slotMap.remove(index);
            return;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof IBitItem)) {
            return;
        }
        IBitItem bitItem = (IBitItem)item;
        BlockInformation state = bitItem.getBlockInformation(stack);
        SlottedBitInventory.BitSlot bitSlot = (SlottedBitInventory.BitSlot)this.slotMap.getOrDefault(index, (Object)new SlottedBitInventory.BitSlot());
        bitSlot.setBlockInformation(state);
        bitSlot.setCount(stack.m_41613_());
        this.slotMap.put(index, (Object)bitSlot);
    }

    public void m_6596_() {
        this.onChange();
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public void m_6211_() {
        this.slotMap.clear();
        this.onChange();
    }

    @Override
    protected void onChange() {
        super.onChange();
        this.toItemStack();
    }

    @Override
    protected int getMaxBitsForSlot() {
        return IServerConfiguration.getInstance().getBagStackSize().get();
    }

    public int m_6893_() {
        return this.getMaxBitsForSlot();
    }

    public boolean m_7983_() {
        return super.isEmpty();
    }
}

