/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.IChiselingManager;
import mod.chiselsandbits.api.chiseling.ILocalChiselingContextCache;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.client.render.preview.chiseling.IChiselContextPreviewRendererRegistry;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.item.chisel.IChiselItem;
import mod.chiselsandbits.api.item.chisel.IChiselingItem;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.named.IDynamicallyHighlightedNameItem;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.notifications.INotificationManager;
import mod.chiselsandbits.chiseling.ChiselingManager;
import mod.chiselsandbits.chiseling.LocalChiselingContextCache;
import mod.chiselsandbits.platforms.core.registries.IChiselsAndBitsRegistryEntry;
import mod.chiselsandbits.registrars.ModTags;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.TranslationUtils;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiselItem
extends DiggerItem
implements IChiselItem,
IDynamicallyHighlightedNameItem {
    private static final Logger LOGGER = LogManager.getLogger();

    public ChiselItem(Tier tier, Item.Properties builderIn) {
        super(0.1f, -2.8f, tier, ModTags.Blocks.CHISELED_BLOCK, builderIn);
    }

    public Component m_7626_(ItemStack stack) {
        if (stack.m_41784_().m_128441_("chiselError")) {
            return Component.Serializer.m_130701_((String)stack.m_41784_().m_128461_("chiselError"));
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        IChiselMode mode = this.getMode(stack);
        if (mode.getGroup().isPresent()) {
            tooltip.add((Component)TranslationUtils.build("chiselmode.mode_grouped", ((IToolModeGroup)mode.getGroup().get()).getDisplayName(), mode.getDisplayName()));
        } else {
            tooltip.add((Component)TranslationUtils.build("chiselmode.mode", mode.getDisplayName()));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    @NotNull
    public IChiselMode getMode(ItemStack stack) {
        CompoundTag stackNbt = stack.m_41784_();
        if (stackNbt.m_128441_("chiselMode")) {
            String chiselModeName = stackNbt.m_128461_("chiselMode");
            try {
                Optional<IChiselMode> registryMode = IChiselMode.getRegistry().get(new ResourceLocation(chiselModeName));
                if (registryMode.isEmpty()) {
                    return IChiselMode.getDefaultMode();
                }
                return registryMode.get();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error(String.format("An ItemStack got loaded with a name that is not a valid chisel mode: %s", chiselModeName));
                this.setMode(stack, IChiselMode.getDefaultMode());
            }
        }
        return IChiselMode.getDefaultMode();
    }

    @Override
    public void setMode(ItemStack stack, IChiselMode mode) {
        if (mode == null) {
            return;
        }
        stack.m_41784_().m_128359_("chiselMode", Objects.requireNonNull(mode.getRegistryName()).toString());
    }

    @Override
    @NotNull
    public Collection<IChiselMode> getPossibleModes() {
        return IChiselMode.getRegistry().getValues().stream().filter(mode -> !mode.requiresPlaceableEditStack()).sorted(Comparator.comparing(IChiselsAndBitsRegistryEntry::getRegistryName)).collect(Collectors.toList());
    }

    @Override
    public ClickProcessingState handleLeftClickProcessing(Player playerEntity, InteractionHand hand, BlockPos position, Direction face, ClickProcessingState currentState) {
        ItemStack itemStack = playerEntity.m_21120_(hand);
        if (itemStack.m_41619_() || itemStack.m_41720_() != this) {
            return currentState;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.m_41720_();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        IChiselingContext context = IChiselingManager.getInstance().getOrCreateContext(playerEntity, chiselMode, ChiselingOperation.CHISELING, false, itemStack);
        ClickProcessingState resultState = chiselMode.onLeftClickBy(playerEntity, context);
        if (context.isComplete()) {
            playerEntity.m_36335_().m_41524_((Item)this, 3);
            ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.CHISELING);
        }
        if (context.getError().isPresent() && context.getWorld().m_5776_()) {
            INotificationManager.getInstance().notify(context.getMode().getIcon(), new Vec3(1.0, 0.0, 0.0), (Component)context.getError().get());
        }
        return resultState;
    }

    @Override
    public void onLeftClickProcessingEnd(Player player, ItemStack stack) {
        IChiselMode chiselMode = this.getMode(stack);
        Optional<IChiselingContext> context = IChiselingManager.getInstance().get(player, chiselMode, ChiselingOperation.CHISELING);
        if (context.isEmpty()) {
            context = LocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        }
        context.ifPresent(c -> {
            chiselMode.onStoppedLeftClicking(player, (IChiselingContext)c);
            if (c.isComplete()) {
                player.m_36335_().m_41524_((Item)this, 3);
                LocalChiselingContextCache.getInstance().clear(ChiselingOperation.CHISELING);
            }
        });
    }

    @Override
    public boolean canUse(Player playerEntity) {
        return ChiselingManager.getInstance().canChisel(playerEntity);
    }

    @Override
    public boolean shouldDrawDefaultHighlight(@NotNull Player playerEntity) {
        ItemStack itemStack = ItemStackUtils.getHighlightItemStackFromPlayer(playerEntity);
        if (itemStack.m_41619_() || itemStack.m_41720_() != this) {
            return true;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.m_41720_();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        Optional<IChiselingContext> potentiallyExistingContext = IChiselingManager.getInstance().get(playerEntity, chiselMode, ChiselingOperation.CHISELING);
        if (potentiallyExistingContext.isPresent()) {
            IChiselingContext context = potentiallyExistingContext.get();
            if (context.getMutator().isPresent()) {
                return false;
            }
            IChiselingContext currentContextSnapshot = context.createSnapshot();
            chiselMode.onLeftClickBy(playerEntity, currentContextSnapshot);
            return currentContextSnapshot.getMutator().isEmpty();
        }
        Optional<IChiselingContext> localCachedContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        if (localCachedContext.isPresent() && localCachedContext.get().getMode().isStillValid(playerEntity, localCachedContext.get(), ChiselingOperation.CHISELING)) {
            IChiselingContext context = localCachedContext.get();
            if (context.getMode() == chiselMode && context.getMutator().isPresent()) {
                return false;
            }
            return context.getMutator().isEmpty();
        }
        IChiselingContext context = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.CHISELING, true, itemStack);
        chiselMode.onLeftClickBy(playerEntity, context);
        if (!context.isComplete()) {
            ILocalChiselingContextCache.getInstance().set(ChiselingOperation.CHISELING, context);
        }
        return context.getMutator().isEmpty();
    }

    @Override
    public void renderHighlight(Player playerEntity, LevelRenderer worldRenderer, PoseStack matrixStack, float partialTicks) {
        IChiselingContext context;
        ItemStack itemStack = ItemStackUtils.getHighlightItemStackFromPlayer(playerEntity);
        if (itemStack.m_41619_() || itemStack.m_41720_() != this) {
            return;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.m_41720_();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        Optional<IChiselingContext> potentiallyExistingContext = IChiselingManager.getInstance().get(playerEntity, chiselMode, ChiselingOperation.CHISELING);
        Optional<IChiselingContext> potentiallyCachedContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        if (potentiallyExistingContext.isPresent()) {
            context = potentiallyExistingContext.get();
            chiselMode.onLeftClickBy(playerEntity, context);
        } else if (potentiallyCachedContext.isPresent() && potentiallyCachedContext.get().getMode() == chiselMode && potentiallyCachedContext.get().getModeOfOperandus() == ChiselingOperation.CHISELING && chiselMode.isStillValid(playerEntity, potentiallyCachedContext.get(), ChiselingOperation.CHISELING)) {
            context = potentiallyCachedContext.get();
        } else {
            context = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.CHISELING, true, itemStack);
            chiselMode.onLeftClickBy(playerEntity, context);
        }
        if (context.getMutator().isEmpty()) {
            ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.CHISELING);
            return;
        }
        if (context.getMutator().isPresent() && context.getError().isEmpty()) {
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, context);
            ILocalChiselingContextCache.getInstance().set(ChiselingOperation.CHISELING, context);
        }
    }

    @Override
    public boolean isDamageableDuringChiseling() {
        return true;
    }

    public int m_41462_() {
        return this.m_43314_().m_6609_() * IServerConfiguration.getInstance().getBitSize().get().getBitsPerBlock();
    }

    public int m_142158_(ItemStack p_150900_) {
        return Math.round(13.0f - (float)p_150900_.m_41773_() * 13.0f / (float)this.m_41462_());
    }

    public int m_142159_(ItemStack p_150901_) {
        float f = Math.max(0.0f, ((float)this.m_41462_() - (float)p_150901_.m_41773_()) / (float)this.m_41462_());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public ItemStack adaptItemStack(ItemStack currentToolStack) {
        Optional<IChiselingContext> chiselingContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        Optional<IChiselingContext> placingContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.PLACING);
        if (chiselingContext.isPresent() && chiselingContext.get().getError().isPresent()) {
            ItemStack errorStack = currentToolStack.m_41777_();
            errorStack.m_41784_().m_128359_("chiselError", Component.Serializer.m_130703_((Component)((Component)chiselingContext.get().getError().get())));
            return errorStack;
        }
        if (placingContext.isPresent() && placingContext.get().getError().isPresent()) {
            ItemStack errorStack = currentToolStack.m_41777_();
            errorStack.m_41784_().m_128359_("chiselError", Component.Serializer.m_130703_((Component)((Component)placingContext.get().getError().get())));
            return errorStack;
        }
        return currentToolStack;
    }
}

