/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.neighborhood;

import java.util.Objects;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;

public final class BlockNeighborhoodEntry {
    private final BlockInformation blockInformation;
    private final IAreaAccessor accessor;
    private final IAreaShapeIdentifier identifier;

    public BlockNeighborhoodEntry(BlockInformation blockInformation, IAreaAccessor accessor) {
        this.blockInformation = blockInformation;
        this.accessor = accessor;
        this.identifier = this.accessor.createNewShapeIdentifier();
    }

    public BlockNeighborhoodEntry(BlockInformation blockInformation) {
        this.blockInformation = blockInformation;
        this.accessor = null;
        this.identifier = IAreaShapeIdentifier.DUMMY;
    }

    public int hashCode() {
        int result = this.blockInformation != null ? this.blockInformation.hashCode() : 0;
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockNeighborhoodEntry)) {
            return false;
        }
        BlockNeighborhoodEntry that = (BlockNeighborhoodEntry)o;
        if (!Objects.equals(this.blockInformation, that.blockInformation)) {
            return false;
        }
        return Objects.equals(this.identifier, that.identifier);
    }

    public BlockInformation getBlockInformation() {
        return this.blockInformation;
    }

    public IAreaAccessor getAccessor() {
        return this.accessor;
    }

    public IAreaShapeIdentifier getIdentifier() {
        return this.identifier;
    }
}

