/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.experimental_features.selective_item_block;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SelectiveBlockItem
extends BlockItem {
    protected final Map<GameProfile, Integer> PLAYER_SELECTED = new WeakHashMap<GameProfile, Integer>();
    protected Block[] blocks;

    public SelectiveBlockItem(List<Block> blocks, Item.Properties builder) {
        this(blocks.toArray(new Block[blocks.size()]), builder);
    }

    public SelectiveBlockItem(Block[] blocks, Item.Properties builder) {
        super(blocks[0], builder);
        this.blocks = blocks;
    }

    public void m_6192_(Map<Block, Item> byBlock, Item item) {
        for (Block block : this.blocks) {
            byBlock.put(block, item);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult actionresulttype = this.tryPlace(new BlockPlaceContext(context));
        return !actionresulttype.m_19077_() && this.m_41472_() ? this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_() : actionresulttype;
    }

    public InteractionResult tryPlace(BlockPlaceContext context) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockitemusecontext = context;
        if (blockitemusecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getStateForPlacement(blockitemusecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.m_7429_(blockitemusecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.m_8083_();
        Level world = blockitemusecontext.m_43725_();
        Player playerentity = blockitemusecontext.m_43723_();
        ItemStack itemstack = blockitemusecontext.m_43722_();
        BlockState blockstate1 = world.m_8055_(blockpos);
        Block block = blockstate1.m_60734_();
        if (block == blockstate.m_60734_()) {
            blockstate1 = this.getStateFromItem(blockpos, world, itemstack, blockstate1);
            this.onBlockPlaced(blockpos, world, playerentity, itemstack, blockstate1);
            block.m_6402_(world, blockpos, blockstate1, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((LevelReader)world, blockpos, (Entity)context.m_43723_());
        world.m_5594_(playerentity, blockpos, this.getPlaceSound(blockstate1, world, blockpos, context.m_43723_()), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (playerentity == null || !playerentity.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    protected BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = this.getCurrentBlock(context.m_43723_().m_36316_()).m_5573_(context);
        return blockstate != null && this.m_40610_(context, blockstate) ? blockstate : null;
    }

    protected boolean m_40610_(BlockPlaceContext context, BlockState state) {
        Player playerentity = context.m_43723_();
        CollisionContext iselectioncontext = playerentity == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)playerentity);
        return state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) && context.m_43725_().m_45752_(state, context.m_8083_(), iselectioncontext);
    }

    private BlockState getStateFromItem(BlockPos pos, Level world, ItemStack itemStack, BlockState state) {
        BlockState blockstate = state;
        CompoundTag compoundnbt = itemStack.m_41783_();
        if (compoundnbt != null) {
            CompoundTag compoundnbt1 = compoundnbt.m_128469_("BlockStateTag");
            StateDefinition statecontainer = state.m_60734_().m_49965_();
            for (String s : compoundnbt1.m_128431_()) {
                Property property = statecontainer.m_61081_(s);
                if (property == null) continue;
                String s1 = compoundnbt1.m_128423_(s).m_7916_();
                blockstate = SelectiveBlockItem.setValueByString(blockstate, property, s1);
            }
        }
        if (blockstate != state) {
            world.m_7731_(pos, blockstate, 2);
        }
        return blockstate;
    }

    public Component m_7626_(ItemStack stack) {
        return new TranslatableComponent(this.m_5671_(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_41466_() {
        return new TranslatableComponent(Minecraft.m_91087_().f_91074_ == null ? this.blocks[0].m_7705_() : this.getCurrentBlock(Minecraft.m_91087_().f_91074_.m_36316_()).m_7705_());
    }

    protected boolean onBlockPlaced(BlockPos pos, Level worldIn, @Nullable Player player, ItemStack stack, BlockState state) {
        return true;
    }

    private static <T extends Comparable<T>> BlockState setValueByString(BlockState state, Property<T> property, String value) {
        return property.m_6215_(value).map(parsedValue -> (BlockState)state.m_61124_(property, parsedValue)).orElse(state);
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 11);
    }

    protected SoundEvent getPlaceSound(BlockState state, Level world, BlockPos pos, Player entity) {
        return state.getSoundType((LevelReader)world, pos, (Entity)entity).m_56777_();
    }

    public Block getCurrentBlock(GameProfile profile) {
        return this.blocks[this.PLAYER_SELECTED.computeIfAbsent(profile, prof -> 0)];
    }

    public int getCurrentIndex(GameProfile profile) {
        return this.PLAYER_SELECTED.computeIfAbsent(profile, prof -> 0);
    }

    public int getMaxIndex() {
        return this.blocks.length - 1;
    }

    public void setPlayerSelected(GameProfile profile, int selected) {
        this.PLAYER_SELECTED.put(profile, Math.min(Math.max(selected, 0), this.blocks.length));
    }

    public static SelectiveBlockItem getHeldSelectiveBlockItem(Player player) {
        Item item = player.m_21205_().m_41720_();
        if (item instanceof SelectiveBlockItem) {
            return (SelectiveBlockItem)item;
        }
        item = player.m_21206_().m_41720_();
        if (item instanceof SelectiveBlockItem) {
            return (SelectiveBlockItem)item;
        }
        return null;
    }
}

