/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.blockentities;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dark_roleplay.projectbrazier.experimental_features.builtin_mixed_model.BuiltinMixedModelData;
import net.dark_roleplay.projectbrazier.feature.blocks.FlowerContainerData;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierBlockEntities;
import net.dark_roleplay.projectbrazier.feature_client.blocks.CFlowerContainerHelper;
import net.dark_roleplay.projectbrazier.util.blocks.ChunkRenderUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.DistExecutor;

public class FlowerContainerBlockEntity
extends BlockEntity {
    protected final int flowerCount;
    protected List<FlowerContainerData> flowers;

    public FlowerContainerBlockEntity(BlockPos pos, BlockState state) {
        this(3, pos, state);
    }

    public FlowerContainerBlockEntity(int flowerCount, BlockPos pos, BlockState state) {
        super((BlockEntityType)BrazierBlockEntities.FLOWER_CONTAINER.get(), pos, state);
        this.flowerCount = flowerCount;
        this.flowers = (List)DistExecutor.unsafeRunForDist(() -> () -> CFlowerContainerHelper.createFlowerData(flowerCount), () -> () -> this.createFlowerData(flowerCount));
    }

    protected List<FlowerContainerData> createFlowerData(int flowerCount) {
        ArrayList<FlowerContainerData> flowers = new ArrayList<FlowerContainerData>(flowerCount);
        for (int i = 0; i < flowerCount; ++i) {
            flowers.add(0, new FlowerContainerData());
        }
        return ImmutableList.copyOf(flowers);
    }

    public ItemStack addFlower(ItemStack stack, Vec3i offset) {
        for (int i = 0; i < this.flowers.size(); ++i) {
            FlowerContainerData flower = this.flowers.get(i);
            if (!flower.getFlower().m_41619_()) continue;
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            flower.setFlower(copy);
            flower.setPlacement(offset);
            stack.m_41774_(1);
            this.m_6596_();
            break;
        }
        return stack;
    }

    public ItemStack removeFlower() {
        for (int i = this.flowers.size() - 1; i >= 0; --i) {
            FlowerContainerData flower = this.flowers.get(i);
            if (flower.getFlower().m_41619_()) continue;
            ItemStack stack = flower.getFlower();
            flower.setFlower(ItemStack.f_41583_);
            this.m_6596_();
            return stack;
        }
        return ItemStack.f_41583_;
    }

    protected List<FlowerContainerData> getFlowerData() {
        return this.flowers;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (!compound.m_128441_("flowers")) {
            return;
        }
        ListTag flowers = compound.m_128437_("flowers", 10);
        for (int i = 0; i < flowers.size(); ++i) {
            if (!flowers.m_128728_(i).m_128456_()) {
                this.flowers.get(i).deserialize(flowers.m_128728_(i));
                continue;
            }
            this.flowers.get(i).setFlower(ItemStack.f_41583_);
        }
        this.requestModelDataUpdate();
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ListTag flowers = new ListTag();
        for (FlowerContainerData flower : this.getFlowerData()) {
            flowers.add((Object)flower.serialize());
        }
        compound.m_128365_("flowers", (Tag)flowers);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        this.requestModelDataUpdate();
        if (this.m_58904_().m_5776_()) {
            ChunkRenderUtils.rerenderChunk((ClientLevel)this.m_58904_(), this.m_58899_());
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new BuiltinMixedModelData(this.getFlowerData());
    }
}

