/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class MargHelperCommand {
    public static final LiteralArgumentBuilder<CommandSourceStack> MARG_GENERATE = (LiteralArgumentBuilder)Commands.m_82127_((String)"marg_generate").then(Commands.m_82129_((String)"target", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> MargHelperCommand.generate((CommandContext<CommandSourceStack>)context)));

    private static int generate(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos starterPos = BlockPosArgument.m_118242_(context, (String)"target");
        BlockPos.MutableBlockPos pos = starterPos.m_122032_();
        Direction[] dirs = new Direction[]{null, Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        ServerLevel lvl = ((CommandSourceStack)context.getSource()).m_81372_();
        String modid = MargHelperCommand.getSignText((Level)lvl, (BlockPos)pos);
        pos.m_122184_(0, 0, 2);
        ArrayList<String> materials = new ArrayList<String>();
        BlockState checkedState = lvl.m_8055_((BlockPos)pos);
        while (checkedState.m_60734_() != Blocks.f_50016_) {
            materials.add(MargHelperCommand.getSignText((Level)lvl, (BlockPos)pos));
            pos.m_122184_(0, 0, 2);
            checkedState = lvl.m_8055_((BlockPos)pos);
        }
        HashMap<String, Block[]> materialBlocks = new HashMap<String, Block[]>();
        HashMap materialTextures = new HashMap();
        pos.m_122190_((Vec3i)starterPos).m_122184_(2, 0, -1);
        BlockState initState = lvl.m_8055_((BlockPos)pos);
        int limitTypes = 50;
        while (initState.m_60734_() != Blocks.f_50752_ && --limitTypes > 0) {
            String material = MargHelperCommand.getSignText((Level)lvl, (BlockPos)pos);
            pos.m_122184_(0, 0, 3);
            Block[] blocks = new Block[materials.size()];
            HashSet<ResourceLocation> textures = new HashSet<ResourceLocation>();
            for (int i = 0; i < blocks.length - 1; ++i) {
                BlockState currentState = lvl.m_8055_((BlockPos)pos);
                blocks[i] = currentState.m_60734_();
                if (blocks[i] == Blocks.f_50016_) {
                    blocks[i] = null;
                }
                pos.m_122184_(0, 0, 2);
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(currentState);
                if (model == Minecraft.m_91087_().m_91304_().m_119409_()) continue;
                for (Direction dir : dirs) {
                    List quads = model.getQuads(currentState, dir, new Random(), (IModelData)EmptyModelData.INSTANCE);
                    for (BakedQuad quad : quads) {
                        textures.add(quad.m_173410_().m_118413_());
                    }
                }
            }
            pos.m_142443_(starterPos.m_123343_() - 1).m_122184_(2, 0, 0);
            initState = lvl.m_8055_((BlockPos)pos);
            materialBlocks.put(material, blocks);
            materialTextures.put(material, textures);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (String material : materialBlocks.keySet()) {
            try {
                Path filePath = Path.of("./marg/" + modid + "/" + material + ".json", new String[0]);
                if (Files.notExists(filePath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                }
                if (Files.notExists(filePath, new LinkOption[0])) {
                    Files.createFile(filePath, new FileAttribute[0]);
                }
                FileWriter writer = new FileWriter(filePath.toFile());
                JsonObject obj = new JsonObject();
                obj.addProperty("materialType", "wood");
                obj.addProperty("requiredMod", modid);
                obj.addProperty("name", material);
                Block[] b = (Block[])materialBlocks.get(material);
                JsonObject itemsJson = new JsonObject();
                JsonObject blocksJson = new JsonObject();
                for (int i = 0; i < b.length; ++i) {
                    if (b[i] == null) continue;
                    Block b2 = b[i];
                    blocksJson.addProperty((String)materials.get(i), b2.getRegistryName().toString());
                    if (b2.m_5456_() == Items.f_41852_) continue;
                    itemsJson.addProperty((String)materials.get(i), b2.m_5456_().getRegistryName().toString());
                }
                obj.add("blocks", (JsonElement)blocksJson);
                obj.add("items", (JsonElement)itemsJson);
                JsonObject texturesJson = new JsonObject();
                Set textures = (Set)materialTextures.get(material);
                int i = 0;
                for (ResourceLocation loc : textures) {
                    texturesJson.addProperty("" + i, loc.toString());
                    ++i;
                }
                obj.add("textures", (JsonElement)texturesJson);
                gson.toJson((JsonElement)obj, (Appendable)writer);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    private static String getSignText(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SignBlockEntity)) {
            return null;
        }
        SignBlockEntity be = (SignBlockEntity)blockEntity;
        Object text = "";
        for (int i = 0; i < 4; ++i) {
            text = (String)text + be.m_155706_(i, false).getString();
        }
        return ((String)text).isEmpty() ? null : text;
    }
}

