/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.containers;

import java.util.function.BiConsumer;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierContainers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class GeneralContainer
extends AbstractContainerMenu {
    protected final BlockPos worldPos;
    private int[] inventories;
    private int teSlots;

    public GeneralContainer(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, playerInventory.f_35978_.m_20193_(), extraData.m_130135_());
    }

    public GeneralContainer(int windowId, Inventory playerInventory, Level world, BlockPos pos) {
        super((MenuType)BrazierContainers.GENERAL_CONTAINER.get(), windowId);
        this.worldPos = pos;
        BlockEntity te = world.m_7702_(pos);
        LazyOptional optionalInventory = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        optionalInventory.ifPresent(handler -> {
            this.teSlots = handler.getSlots();
            this.inventories = new int[]{handler.getSlots(), 36};
            this.executeGrid(9, handler.getSlots(), (x, y) -> this.m_38897_((Slot)new SlotItemHandler(handler, x + y * 9, 8 + x * 18, 17 + y * 18)));
        });
        int yOffset = (int)(30.0 + Math.ceil((float)this.teSlots / 9.0f) * 18.0);
        for (int x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot((Container)playerInventory, x2, 8 + x2 * 18, yOffset + 56));
        }
        this.executeGrid(9, 27, (x, y) -> this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, yOffset + y * 18)));
        if (this.inventories == null) {
            this.inventories = new int[]{36};
        }
    }

    public int getTESlotCount() {
        return this.teSlots;
    }

    public boolean m_6875_(Player player) {
        return this.worldPos.m_123314_((Vec3i)player.m_142538_(), 5.0);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            boolean hadSuccess = false;
            int startIndex = 0;
            int endIndex = -1;
            for (int i = 0; i < this.inventories.length; ++i) {
                startIndex = endIndex + 1;
                if (index >= startIndex && index < (endIndex += this.inventories[i]) || this.m_38903_(itemstack1, startIndex, endIndex, false)) continue;
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    private void executeGrid(int width, int size, BiConsumer<Integer, Integer> method) {
        float widthF = width;
        for (int i = 0; i < size; ++i) {
            method.accept(i % width, (int)Math.floor((float)i / widthF));
        }
    }
}

