/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.entities;

import com.mojang.math.Vector3f;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierSounds;
import net.dark_roleplay.projectbrazier.util.data.NBTUtil2;
import net.dark_roleplay.projectbrazier.util.math.vector.VectorUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class ZiplineEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static int STEPS = 100;
    double[] LUT;
    float accel = 0.02f;
    float speed = 0.05f;
    double dist = 0.0;
    Vector3f start;
    Vector3f end;
    Vector3f mid;

    public ZiplineEntity(EntityType<?> type, Level world) {
        this(type, world, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public ZiplineEntity(EntityType<?> type, Level world, Vector3f start, Vector3f end, Vector3f mid) {
        super(type, world);
        this.start = start.m_122281_();
        this.end = end.m_122281_();
        this.mid = mid.m_122281_();
        this.start.setY(this.start.m_122260_() - 2.1875f);
        this.end.setY(this.end.m_122260_() - 2.1875f);
        this.mid.setY(this.mid.m_122260_() - 2.1875f);
        this.m_146922_((float)(Math.atan2(end.m_122269_() - start.m_122269_(), end.m_122239_() - start.m_122239_()) * 180.0 / Math.PI) - 90.0f);
        this.f_19859_ = this.m_146908_();
        this.m_6034_(start.m_122239_(), start.m_122260_(), start.m_122269_());
        this.calculateLUT(start, end, mid);
    }

    public double m_6048_() {
        return 0.5;
    }

    private void calculateLUT(Vector3f start, Vector3f end, Vector3f mid) {
        this.LUT = new double[STEPS + 1];
        double currentDistance = 0.0;
        Vector3f currentPos = start;
        this.LUT[0] = 0.0;
        for (int i = 1; i <= STEPS; ++i) {
            Vector3f bezierPos = ZiplineEntity.getBezierPos(start, end, mid, (float)i / (float)STEPS);
            currentPos = bezierPos;
            this.LUT[i] = currentDistance += (double)VectorUtils.getDistance(currentPos, bezierPos);
        }
    }

    protected void m_8097_() {
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7340_(Entity entityToUpdate) {
        entityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-95.0f, (float)95.0f);
        entityToUpdate.f_19859_ += f1 - f;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + f1 - f);
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 3 == 0) {
            this.m_5496_((SoundEvent)BrazierSounds.ZIPLINE.get(), 1.0f, 1.0f);
        }
        this.dist += (double)this.speed;
        this.speed = Math.min(1.0f, this.speed + this.accel);
        double progress = ZiplineEntity.distToT(this.LUT, this.dist);
        if (this.dist + (double)this.speed + 0.25 > this.LUT[this.LUT.length - 1] && !this.m_183503_().f_46443_) {
            this.m_20197_().forEach(passenger -> {
                passenger.m_8127_();
                passenger.m_20256_(new Vec3(0.0, 5.0, 5.0));
            });
        }
        if (progress >= 1.0 && !this.m_183503_().f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        Vector3f newPos = ZiplineEntity.getBezierPos(this.start, this.end, this.mid, progress);
        this.m_6034_(newPos.m_122239_(), newPos.m_122260_(), newPos.m_122269_());
        if (!this.m_183503_().f_46443_ && !this.m_20160_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.start = NBTUtil2.readVector3f(compound.m_128469_("start"));
        this.end = NBTUtil2.readVector3f(compound.m_128469_("end"));
        this.mid = NBTUtil2.readVector3f(compound.m_128469_("mid"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("start", (Tag)NBTUtil2.writeVector3f(this.start));
        compound.m_128365_("end", (Tag)NBTUtil2.writeVector3f(this.end));
        compound.m_128365_("mid", (Tag)NBTUtil2.writeVector3f(this.mid));
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        double progress = ZiplineEntity.distToT(this.LUT, this.dist + (double)this.speed);
        Vec3 speed = new Vec3(VectorUtils.subtract(ZiplineEntity.getBezierPos(this.start, this.end, this.mid, progress), this.m_20182_())).m_82542_(5.0, 5.0, 5.0);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static double distToT(double[] lut, double distance) {
        double arcLength = lut[lut.length - 1];
        int n = lut.length;
        if (distance > 0.0 && distance < arcLength) {
            for (int i = 0; i < n - 1; ++i) {
                if (!(distance > lut[i]) || !(distance < lut[i + 1])) continue;
                return Mth.m_14139_((double)((distance - lut[i]) / (lut[i + 1] - lut[i])), (double)((float)i / ((float)n - 1.0f)), (double)((float)(i + 1) / ((float)n - 1.0f)));
            }
        }
        return distance / arcLength;
    }

    public static Vector3f getBezierPos(Vector3f bezierStart, Vector3f bezierEnd, Vector3f bezierMid, double progress) {
        Vector3f a = VectorUtils.lerpVector(bezierStart, bezierMid, progress);
        Vector3f b = VectorUtils.lerpVector(bezierMid, bezierEnd, progress);
        return VectorUtils.lerpVector(a, b, progress);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        this.m_7380_(tag);
        buffer.m_130079_(tag);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_7378_(additionalData.m_130260_());
        this.calculateLUT(this.start, this.end, this.mid);
    }
}

