/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.mechanics.spreader;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.dark_roleplay.projectbrazier.feature.mechanics.spreader.ISpreadingBehavior;
import net.dark_roleplay.projectbrazier.feature.mechanics.spreader.SpreaderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpreadBehaviors {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Block, Map<SpreaderType, ISpreadingBehavior>> SPREADERS = new HashMap<Block, Map<SpreaderType, ISpreadingBehavior>>();

    public static void addSpreaderBehavior(Block block, SpreaderType type, ISpreadingBehavior behavior) {
        Map blockSpecificSpreaders = SPREADERS.computeIfAbsent(block, key -> new HashMap());
        if (blockSpecificSpreaders.containsKey(type)) {
            LOGGER.info("Replacing spreading behavior for block '{}' and spreader type '{}'", (Object)block.getRegistryName(), (Object)type.getName());
        }
        blockSpecificSpreaders.put(type, behavior);
    }

    public static boolean canSpread(BlockState state, SpreaderType type) {
        return SpreadBehaviors.getSpreadingBehavior(state.m_60734_(), type) != null;
    }

    public static BlockState getSpreadState(BlockState state, Level level, BlockPos pos, SpreaderType type) {
        ISpreadingBehavior behavior = SpreadBehaviors.getSpreadingBehavior(state.m_60734_(), type);
        if (behavior == null) {
            return state;
        }
        return behavior.getSpreadingState(state, level, pos);
    }

    @Nullable
    private static ISpreadingBehavior getSpreadingBehavior(Block block, SpreaderType type) {
        return SPREADERS.containsKey(block) ? SPREADERS.get(block).get(type) : null;
    }
}

