/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature_client.blockentityrenderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.dark_roleplay.projectbrazier.feature.blockentities.BarrelBlockEntity;
import net.dark_roleplay.projectbrazier.feature.blocks.BarrelStorageType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BarrelBlockEntityRenderer
implements BlockEntityRenderer<BarrelBlockEntity> {
    public BarrelBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BarrelBlockEntity tileEntity, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        LazyOptional lazyTank = tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        if (tileEntity.getStorageType() != BarrelStorageType.FLUID || !lazyTank.isPresent()) {
            return;
        }
        IFluidHandler tank = (IFluidHandler)lazyTank.orElse(null);
        if (tank == null) {
            return;
        }
        FluidStack fluid = tank.getFluidInTank(0);
        if (fluid.isEmpty()) {
            return;
        }
        float maxCapacity = tank.getTankCapacity(0);
        int content = fluid.getAmount();
        ResourceLocation fluidTexture = fluid.getFluid().getAttributes().getStillTexture(fluid);
        TextureAtlasSprite fluidSprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(fluidTexture);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110469_());
        this.createQuad(matrix.m_85850_().m_85861_(), builder, Mth.m_14179_((float)((float)content / maxCapacity), (float)0.125f, (float)0.875f), fluidSprite, combinedLight, fluid.getFluid().getAttributes().getColor());
    }

    private void createQuad(Matrix4f matrix, VertexConsumer builder, float verticalOffset, TextureAtlasSprite sprite, int light, int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.m_85982_(matrix, 0.125f, verticalOffset, 0.875f).m_6122_(r, g, b, 255).m_7421_(sprite.m_118367_(0.0), sprite.m_118393_(0.0)).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, 0.875f, verticalOffset, 0.875f).m_6122_(r, g, b, 255).m_7421_(sprite.m_118367_(16.0), sprite.m_118393_(0.0)).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, 0.875f, verticalOffset, 0.125f).m_6122_(r, g, b, 255).m_7421_(sprite.m_118367_(16.0), sprite.m_118393_(16.0)).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_85982_(matrix, 0.125f, verticalOffset, 0.125f).m_6122_(r, g, b, 255).m_7421_(sprite.m_118367_(0.0), sprite.m_118393_(16.0)).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }
}

