/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature_client.listeners;

import net.dark_roleplay.projectbrazier.feature.items.SpyglassItem;
import net.dark_roleplay.projectbrazier.feature_client.registrars.BrazierKeybinds;
import net.dark_roleplay.projectbrazier.feature_client.screens.SpyglassOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="projectbrazier", value={Dist.CLIENT})
public class SpyglassListeners {
    private static int prevZoom = 0;
    private static int zoom = 0;
    private static double prevFOV = 0.0;
    private static double targetFOV = 0.0;
    private static long deltaTimeEnd = 0L;
    private static boolean initSmoothCamera = false;
    private static boolean isZoomActive = false;

    @SubscribeEvent
    public static void mouseScroll(InputEvent.MouseScrollEvent event) {
        SpyglassItem spyglassItem = SpyglassListeners.getHeldZoomItem();
        if (SpyglassListeners.isZoomActive()) {
            double scroll = event.getScrollDelta();
            if (scroll > 0.0) {
                SpyglassListeners.increaseZoom(spyglassItem);
            } else if (scroll < 0.0) {
                SpyglassListeners.decreaseZoom(spyglassItem);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void updateFov(EntityViewRenderEvent.FieldOfView event) {
        SpyglassItem spyglassItem = SpyglassListeners.getHeldZoomItem();
        if (spyglassItem != null && (SpyglassListeners.isZoomActive() || deltaTimeEnd > System.currentTimeMillis())) {
            event.setFOV(SpyglassListeners.getNewFOV());
        } else if (zoom > 0) {
            SpyglassListeners.resetZoom();
            zoom = 0;
        }
    }

    @SubscribeEvent
    public static void GameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (SpyglassListeners.isZoomActive() || deltaTimeEnd > System.currentTimeMillis()) {
            SpyglassOverlay.INSTANCE.m_6305_(event.getMatrixStack(), 0, 0, 0.0f);
        }
    }

    @SubscribeEvent
    public static void GameOverlay(RenderHandEvent event) {
        if (SpyglassListeners.isZoomActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void keyInput(InputEvent.KeyInputEvent event) {
        SpyglassItem spyglassItem;
        if (BrazierKeybinds.INC_ZOOM_ALT.getKeyConflictContext().isActive() && BrazierKeybinds.INC_ZOOM_ALT.m_90859_() && (spyglassItem = SpyglassListeners.getHeldZoomItem()) != null) {
            SpyglassListeners.increaseZoom(spyglassItem);
        }
        if (BrazierKeybinds.DEC_ZOOM_ALT.getKeyConflictContext().isActive() && BrazierKeybinds.DEC_ZOOM_ALT.m_90859_() && (spyglassItem = SpyglassListeners.getHeldZoomItem()) != null) {
            SpyglassListeners.decreaseZoom(spyglassItem);
        }
    }

    public static boolean isZoomActive() {
        isZoomActive = isZoomActive && SpyglassListeners.getHeldZoomItem() != null;
        return isZoomActive;
    }

    public static void toogleZoom() {
        SpyglassItem spyglass = SpyglassListeners.getHeldZoomItem();
        if (spyglass != null) {
            if (isZoomActive) {
                isZoomActive = false;
                prevZoom = zoom;
                zoom = 0;
                SpyglassListeners.updateLerpHelpers(spyglass);
                SpyglassListeners.resetZoom();
            } else {
                isZoomActive = true;
                SpyglassListeners.increaseZoom(spyglass);
            }
        }
    }

    public static void increaseZoom(SpyglassItem spyglassItem) {
        int maxZoom = spyglassItem.getZoomCount();
        if (zoom < maxZoom) {
            if (zoom == 0) {
                SpyglassListeners.setupZoom();
            }
            prevZoom = zoom++;
            SpyglassListeners.updateLerpHelpers(spyglassItem);
        }
    }

    public static void decreaseZoom(SpyglassItem spyglassItem) {
        if (zoom != 0) {
            prevZoom = zoom--;
            if (zoom <= 0) {
                SpyglassListeners.resetZoom();
            }
            SpyglassListeners.updateLerpHelpers(spyglassItem);
        }
    }

    private static double getNewFOV() {
        if (deltaTimeEnd > System.currentTimeMillis()) {
            return Mth.m_14139_((double)(1.0f - (float)(deltaTimeEnd - System.currentTimeMillis()) / 250.0f), (double)prevFOV, (double)targetFOV);
        }
        return targetFOV;
    }

    private static void updateLerpHelpers(SpyglassItem spyglassItem) {
        if (prevZoom != 0) {
            if (deltaTimeEnd > System.currentTimeMillis()) {
                float delta = 1.0f - (float)(deltaTimeEnd - System.currentTimeMillis()) / 250.0f;
                prevFOV = Mth.m_14139_((double)delta, (double)prevFOV, (double)targetFOV);
            } else {
                prevFOV = targetFOV;
            }
        } else {
            prevFOV = Minecraft.m_91087_().f_91066_.f_92068_;
        }
        targetFOV = zoom > 0 ? (double)spyglassItem.getZoomFOVs()[zoom - 1] : Minecraft.m_91087_().f_91066_.f_92068_;
        deltaTimeEnd = System.currentTimeMillis() + 250L;
    }

    private static SpyglassItem getHeldZoomItem() {
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21205_();
        if (stack.m_41720_() instanceof SpyglassItem) {
            return (SpyglassItem)stack.m_41720_();
        }
        stack = Minecraft.m_91087_().f_91074_.m_21206_();
        if (stack.m_41720_() instanceof SpyglassItem) {
            return (SpyglassItem)stack.m_41720_();
        }
        return null;
    }

    private static void setupZoom() {
        initSmoothCamera = Minecraft.m_91087_().f_91066_.f_92067_;
        Minecraft.m_91087_().f_91066_.f_92067_ = true;
    }

    private static void resetZoom() {
        Minecraft.m_91087_().f_91066_.f_92067_ = initSmoothCamera;
    }
}

