/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature_client.model_loaders.axis_connected_models;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.axis_connected_models.AxisConnectedModelData;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.axis_connected_models.AxisConnectionType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class AxisConnectedModel
implements IModelGeometry {
    UnbakedModel defaultModel;
    UnbakedModel positiveModel;
    UnbakedModel negativeModel;
    UnbakedModel centeredModel;

    public AxisConnectedModel(UnbakedModel defaultModel, UnbakedModel positiveModel, UnbakedModel negativeModel, UnbakedModel centeredModel) {
        this.defaultModel = defaultModel;
        this.positiveModel = positiveModel;
        this.negativeModel = negativeModel;
        this.centeredModel = centeredModel;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new ConnectedBakedModel(this.defaultModel.m_7611_(bakery, spriteGetter, modelTransform, modelLocation), this.positiveModel == null ? null : this.positiveModel.m_7611_(bakery, spriteGetter, modelTransform, modelLocation), this.negativeModel == null ? null : this.negativeModel.m_7611_(bakery, spriteGetter, modelTransform, modelLocation), this.centeredModel.m_7611_(bakery, spriteGetter, modelTransform, modelLocation));
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function modelGetter, Set missingTextureErrors) {
        HashSet<Material> textures = new HashSet<Material>();
        textures.addAll(this.defaultModel.m_5500_(modelGetter, missingTextureErrors));
        if (this.positiveModel != null) {
            textures.addAll(this.positiveModel.m_5500_(modelGetter, missingTextureErrors));
        }
        if (this.negativeModel != null) {
            textures.addAll(this.negativeModel.m_5500_(modelGetter, missingTextureErrors));
        }
        textures.addAll(this.centeredModel.m_5500_(modelGetter, missingTextureErrors));
        return textures;
    }

    public static class ConnectedBakedModel
    extends BakedModelWrapper {
        protected BakedModel positiveModel;
        protected BakedModel negativeModel;
        protected BakedModel centeredModel;

        public ConnectedBakedModel(BakedModel defaultModel, BakedModel positiveModel, BakedModel negativeModel, BakedModel centeredModel) {
            super(defaultModel);
            this.positiveModel = positiveModel == null ? centeredModel : positiveModel;
            this.negativeModel = negativeModel == null ? centeredModel : negativeModel;
            this.centeredModel = centeredModel;
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            if (extraData instanceof AxisConnectedModelData) {
                switch ((AxisConnectionType)((Object)extraData.getData(AxisConnectedModelData.CONNECTION))) {
                    case DEFAULT: {
                        return this.originalModel.getQuads(state, side, rand, extraData);
                    }
                    case POSITIVE: {
                        return this.positiveModel.getQuads(state, side, rand, extraData);
                    }
                    case NEGATIVE: {
                        return this.negativeModel.getQuads(state, side, rand, extraData);
                    }
                    case CENTERED: {
                        return this.centeredModel.getQuads(state, side, rand, extraData);
                    }
                }
            }
            return this.originalModel.getQuads(state, side, rand, extraData);
        }

        @Nonnull
        public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
            AxisConnectedModelData data = new AxisConnectedModelData();
            data.setData(AxisConnectedModelData.CONNECTION, (Object)AxisConnectionType.getConnections((BlockGetter)world, pos, state));
            return data;
        }
    }

    public static class Loader
    implements IModelLoader {
        public void m_6213_(ResourceManager resourceManager) {
        }

        public IModelGeometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            UnbakedModel defaultModel = null;
            UnbakedModel positiveModel = null;
            UnbakedModel negativeModel = null;
            UnbakedModel centeredModel = null;
            if (modelContents.has("default")) {
                defaultModel = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"default"), BlockModel.class);
            }
            if (modelContents.has("positive")) {
                positiveModel = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"positive"), BlockModel.class);
            }
            if (modelContents.has("negative")) {
                negativeModel = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"negative"), BlockModel.class);
            }
            if (modelContents.has("centered")) {
                centeredModel = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"centered"), BlockModel.class);
            }
            if (modelContents.has("single")) {
                defaultModel = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"single"), BlockModel.class);
            }
            if (modelContents.has("multi")) {
                centeredModel = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"multi"), BlockModel.class);
            }
            return new AxisConnectedModel(defaultModel, positiveModel, negativeModel, centeredModel);
        }
    }
}

