/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature_client.model_loaders.block_specific.roof_model_loader;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.block_specific.roof_model_loader.util.RoofModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class RoofModel
implements IModelGeometry<RoofModel> {
    private final float height;
    private final float width;
    private final float length;
    private final float verticalOffset;
    private final float horizontalOffset;
    private final int steps;
    private Map<String, String> textures = new HashMap<String, String>();
    private Map<String, Material> compiledTextures = new HashMap<String, Material>();
    private final int tileOffset;

    public RoofModel(float height, float width, float length, int steps, float verticalOffset, float horizontalOffset, int tileOffset) {
        this.height = height;
        this.width = width;
        this.length = length;
        this.steps = steps;
        this.verticalOffset = verticalOffset;
        this.horizontalOffset = horizontalOffset;
        this.tileOffset = tileOffset;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public float getLength() {
        return this.length;
    }

    public float getVerticalOffset() {
        return this.verticalOffset;
    }

    public float getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public int getTileOffset() {
        return this.tileOffset;
    }

    public int getSteps() {
        return this.steps;
    }

    public void addTexture(String key, String value) {
        this.textures.put(key, value);
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function modelGetter, Set missingTextureErrors) {
        if (this.compiledTextures.isEmpty()) {
            for (Map.Entry<String, String> texture : this.textures.entrySet()) {
                this.compiledTextures.put(texture.getKey(), new Material(InventoryMenu.f_39692_, new ResourceLocation(texture.getValue())));
            }
        }
        return this.compiledTextures.values();
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        Vector3f translation = modelTransform.m_6189_().m_175940_();
        Vector3f scale = modelTransform.m_6189_().m_175941_();
        Quaternion rotation = modelTransform.m_6189_().m_121105_();
        PoseStack stack = new PoseStack();
        stack.m_85841_(scale.m_122239_(), scale.m_122260_(), scale.m_122269_());
        stack.m_85837_((double)translation.m_122239_(), (double)translation.m_122260_(), (double)translation.m_122269_());
        stack.m_85845_(rotation);
        RoofModelGenerator generator = new RoofModelGenerator(this.width, this.height, this.steps, new Vector3f(0.0f, this.verticalOffset, this.horizontalOffset), this.tileOffset, stack, spriteGetter, this.compiledTextures);
        EnumMap model = new EnumMap(Direction.class);
        for (Direction dir : Direction.values()) {
            model.put(dir, new ArrayList());
        }
        return new SimpleBakedModel(generator.getFull(), model, false, owner.isSideLit(), owner.isShadedInGui(), spriteGetter.apply(this.compiledTextures.get("particle")), owner.getCameraTransforms(), ItemOverrides.f_111734_);
    }
}

