/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature_client.model_loaders.emissive;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class EmissiveModel
implements IModelGeometry {
    private final UnbakedModel emissiveModel;
    private final UnbakedModel nonEmissiveModel;
    private final int skyLight;
    private final int blockLight;

    public EmissiveModel(UnbakedModel emissiveModel, UnbakedModel nonEmissiveModel, int skyLight, int blockLight) {
        this.emissiveModel = emissiveModel;
        this.nonEmissiveModel = nonEmissiveModel;
        this.skyLight = skyLight;
        this.blockLight = blockLight;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        BakedModel preEmissiveBakedModel;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.nonEmissiveModel != null) {
            builder.put((Object)"non_emissive", (Object)this.nonEmissiveModel.m_7611_(bakery, spriteGetter, modelTransform, modelLocation));
        }
        if ((preEmissiveBakedModel = this.emissiveModel.m_7611_(bakery, spriteGetter, modelTransform, modelLocation)) instanceof SimpleBakedModel) {
            List<BakedQuad> quads = EmissiveModel.transformQuads(preEmissiveBakedModel.getQuads(null, null, null, (IModelData)EmptyModelData.INSTANCE), this.skyLight, this.blockLight);
            EnumMap<Direction, List<BakedQuad>> faceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
            for (Direction dir : Direction.values()) {
                faceQuads.put(dir, EmissiveModel.transformQuads(preEmissiveBakedModel.getQuads(null, dir, null, (IModelData)EmptyModelData.INSTANCE), this.skyLight, this.blockLight));
            }
            builder.put((Object)"emissive", (Object)new SimpleBakedModel(quads, faceQuads, preEmissiveBakedModel.m_7541_(), preEmissiveBakedModel.m_7547_(), preEmissiveBakedModel.m_7539_(), preEmissiveBakedModel.m_6160_(), preEmissiveBakedModel.m_7442_(), preEmissiveBakedModel.m_7343_()));
        }
        return new CompositeModel(owner.isShadedInGui(), owner.isSideLit(), owner.useSmoothLighting(), (TextureAtlasSprite)spriteGetter.apply(owner.resolveTexture("particle")), builder.build(), owner.getCombinedTransform(), overrides);
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function modelGetter, Set missingTextureErrors) {
        HashSet<Material> textures = new HashSet<Material>();
        textures.addAll(this.emissiveModel.m_5500_(modelGetter, missingTextureErrors));
        if (this.nonEmissiveModel != null) {
            textures.addAll(this.nonEmissiveModel.m_5500_(modelGetter, missingTextureErrors));
        }
        return textures;
    }

    private static List<BakedQuad> transformQuads(List<BakedQuad> quads, int skyLight, int blockLight) {
        int light = blockLight << 4 | skyLight << 20;
        return quads.stream().map(quad -> EmissiveModel.transformQuad(quad, light)).collect(Collectors.toList());
    }

    private static BakedQuad transformQuad(BakedQuad quad, int skyLight, int blockLight) {
        return EmissiveModel.transformQuad(quad, blockLight << 4 | skyLight << 20);
    }

    private static BakedQuad transformQuad(BakedQuad quad, int light) {
        int[] vertexData = (int[])quad.m_111303_().clone();
        vertexData[6] = light;
        vertexData[14] = light;
        vertexData[22] = light;
        vertexData[30] = light;
        return new BakedQuad(vertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    public static class Loader
    implements IModelLoader {
        public void m_6213_(ResourceManager resourceManager) {
        }

        public IModelGeometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            UnbakedModel nonEmissive = null;
            UnbakedModel emissive = null;
            if (modelContents.has("nonEmissive")) {
                nonEmissive = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"nonEmissive"), BlockModel.class);
            }
            if (modelContents.has("emissive")) {
                emissive = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"emissive"), BlockModel.class);
            }
            int skyLight = GsonHelper.m_13824_((JsonObject)modelContents, (String)"skyLight", (int)15);
            int blockLight = GsonHelper.m_13824_((JsonObject)modelContents, (String)"blockLight", (int)15);
            return new EmissiveModel(emissive, nonEmissive, skyLight, blockLight);
        }
    }
}

