/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.util.blocks;

import java.util.HashSet;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class VoxelShapeHelper {
    public static VoxelShape rotateShape(VoxelShape shape, Direction direction) {
        if (direction == Direction.NORTH) {
            return shape;
        }
        HashSet rotatedShapes = new HashSet();
        shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            y1 = y1 * 16.0 - 8.0;
            y2 = y2 * 16.0 - 8.0;
            x1 = x1 * 16.0 - 8.0;
            x2 = x2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            if (direction == Direction.EAST) {
                rotatedShapes.add(VoxelShapeHelper.constructBoxSafe(8.0 - z1, y1 + 8.0, 8.0 + x1, 8.0 - z2, y2 + 8.0, 8.0 + x2));
            } else if (direction == Direction.SOUTH) {
                rotatedShapes.add(VoxelShapeHelper.constructBoxSafe(8.0 - x1, y1 + 8.0, 8.0 - z1, 8.0 - x2, y2 + 8.0, 8.0 - z2));
            } else if (direction == Direction.WEST) {
                rotatedShapes.add(VoxelShapeHelper.constructBoxSafe(8.0 + z1, y1 + 8.0, 8.0 - x1, 8.0 + z2, y2 + 8.0, 8.0 - x2));
            } else if (direction == Direction.UP) {
                rotatedShapes.add(VoxelShapeHelper.constructBoxSafe(x1 + 8.0, 8.0 - z2, 8.0 + y1, x2 + 8.0, 8.0 - z1, 8.0 + y2));
            } else if (direction == Direction.DOWN) {
                rotatedShapes.add(VoxelShapeHelper.constructBoxSafe(x1 + 8.0, 8.0 + z1, 8.0 - y2, x2 + 8.0, 8.0 + z2, 8.0 - y1));
            }
        });
        return (VoxelShape)rotatedShapes.stream().reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    }

    private static VoxelShape constructBoxSafe(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.m_49796_((double)Math.min(x1, x2), (double)Math.min(y1, y2), (double)Math.min(z1, z2), (double)Math.max(x1, x2), (double)Math.max(y1, y2), (double)Math.max(z1, z2));
    }
}

