/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.util.marg;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class EnumMaterialRegistryObject<E extends Enum<E>, T extends IForgeRegistryEntry<? super T>> {
    private Map<E, Map<MargMaterial, RegistryObject<T>>> objects;

    public EnumMaterialRegistryObject(Class<E> clazz) {
        this.objects = new EnumMap<E, Map<MargMaterial, RegistryObject<T>>>(clazz);
    }

    public void register(E key, MargMaterial matKey, RegistryObject<T> obj) {
        Map subObjects = this.objects.computeIfAbsent(key, key2 -> new HashMap());
        subObjects.put(matKey, obj);
    }

    public RegistryObject<T> getRegistryObject(E key, MargMaterial magKey) {
        Map<MargMaterial, RegistryObject<T>> subObjects = this.objects.get(key);
        return subObjects == null ? null : subObjects.get(key);
    }

    public T get(E key, MargMaterial matKey) {
        Map<MargMaterial, RegistryObject<T>> subObjects = this.objects.get(key);
        RegistryObject<T> val = subObjects == null ? null : subObjects.get(key);
        return (T)(val == null ? null : (IForgeRegistryEntry)val.get());
    }

    public Collection<RegistryObject<T>> values() {
        return this.objects.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
    }
}

