/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.util.math.bezier;

import com.mojang.math.Vector3f;
import net.dark_roleplay.projectbrazier.util.math.BezierUtils;
import net.minecraft.world.phys.Vec2;

public class BezierCurve {
    private BezierCurve origin;
    private final double[] lookupTable;
    private final Vector3f[] controlPoints;
    private final Vector3f[] bezierPoints;
    private final int resolution;

    public BezierCurve(Vector3f[] controlPoints, int resolution) {
        this(null, controlPoints, resolution);
    }

    public BezierCurve(BezierCurve origin, Vector3f[] controlPoints, int resolution) {
        this.origin = origin;
        this.controlPoints = controlPoints;
        this.resolution = resolution;
        this.lookupTable = BezierUtils.calculateLookupTable(this.controlPoints[0], this.controlPoints[1], this.controlPoints[2], this.resolution);
        this.bezierPoints = new Vector3f[(int)Math.ceil(this.lookupTable[this.lookupTable.length - 1]) + 1];
        for (int i = 0; i < this.bezierPoints.length; ++i) {
            double progress = 0.0;
            progress = origin != null ? BezierUtils.getProgressForDistance(origin.lookupTable, Math.min((double)i, origin.lookupTable[origin.lookupTable.length - 1])) : BezierUtils.getProgressForDistance(this.lookupTable, Math.min((double)i, this.lookupTable[this.lookupTable.length - 1]));
            this.bezierPoints[i] = BezierUtils.getBezierPos(this.controlPoints[0], this.controlPoints[1], this.controlPoints[2], progress);
        }
    }

    public static BezierCurve createLocal(Vector3f bezierOrigin, Vector3f bezierMid, Vector3f bezierEnd, int resolution) {
        float vertOffset = bezierOrigin.m_122260_() - bezierMid.m_122260_();
        return new BezierCurve(new Vector3f[]{new Vector3f(0.0f, vertOffset, 0.0f), new Vector3f(bezierMid.m_122239_() - bezierOrigin.m_122239_(), 0.0f, bezierMid.m_122269_() - bezierOrigin.m_122269_()), new Vector3f(bezierEnd.m_122239_() - bezierOrigin.m_122239_(), bezierEnd.m_122260_() - bezierOrigin.m_122260_() + vertOffset, bezierEnd.m_122269_() - bezierOrigin.m_122269_())}, resolution);
    }

    public static BezierCurve createGlobal(Vector3f bezierOrigin, Vector3f bezierMid, Vector3f bezierEnd, int resolution) {
        return new BezierCurve(new Vector3f[]{bezierOrigin, bezierMid, bezierEnd}, resolution);
    }

    public Vector3f[] getControlPoints() {
        return this.controlPoints;
    }

    public Vector3f[] getBezierPoints() {
        return this.bezierPoints;
    }

    public BezierCurve offset(float vertical, float horizontal) {
        Vector3f pStart = this.getPerpForIndex(0, vertical);
        Vector3f pEnd = this.getPerpForIndex(2, vertical);
        Vec2 hor = new Vec2(this.controlPoints[2].m_122269_() - this.controlPoints[0].m_122269_(), -(this.controlPoints[2].m_122239_() - this.controlPoints[0].m_122239_()));
        hor = hor.m_165902_().m_165903_(horizontal);
        Vector3f centerOffset = new Vector3f(pStart.m_122239_() + pEnd.m_122239_(), pStart.m_122260_() + pEnd.m_122260_(), pStart.m_122269_() + pEnd.m_122269_());
        centerOffset.m_122261_(0.5f);
        return new BezierCurve(this, new Vector3f[]{new Vector3f(this.controlPoints[0].m_122239_() + hor.f_82470_ + pStart.m_122239_(), this.controlPoints[0].m_122260_() + pStart.m_122260_(), this.controlPoints[0].m_122269_() + hor.f_82471_ + pStart.m_122269_()), new Vector3f(this.controlPoints[1].m_122239_() + hor.f_82470_ + centerOffset.m_122239_(), this.controlPoints[1].m_122260_() + centerOffset.m_122260_(), this.controlPoints[1].m_122269_() + hor.f_82471_ + centerOffset.m_122269_()), new Vector3f(this.controlPoints[2].m_122239_() + hor.f_82470_ + pEnd.m_122239_(), this.controlPoints[2].m_122260_() + pEnd.m_122260_(), this.controlPoints[2].m_122269_() + hor.f_82471_ + pEnd.m_122269_())}, this.resolution);
    }

    public double getLength() {
        return this.lookupTable[this.lookupTable.length - 1];
    }

    private Vector3f getPerpForIndex(int index, float vertOffset) {
        double x2 = this.controlPoints[1].m_122239_() - this.controlPoints[index].m_122239_();
        double z2 = this.controlPoints[1].m_122269_() - this.controlPoints[index].m_122269_();
        double v = Math.abs(z2) + Math.abs(x2);
        float ratio = (float)(x2 / v);
        float rRatio = (float)(z2 / v);
        Vec2 temp = new Vec2((float)Math.sqrt(x2 * x2 + z2 * z2), this.controlPoints[1].m_122260_() - this.controlPoints[index].m_122260_());
        Vec2 perp = new Vec2(-temp.f_82471_, temp.f_82470_).m_165902_().m_165903_(vertOffset);
        return new Vector3f(perp.f_82470_ * ratio, perp.f_82471_, perp.f_82470_ * rRatio);
    }
}

