/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ClientUtils;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.ChestState;
import xfacthd.framedblocks.common.data.LatchType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedChestModel
extends FramedBlockModel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("framedblocks", "block/framed_chest_lock");
    private final Direction facing;
    private final boolean closed;
    private final LatchType latch;

    public FramedChestModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        this.closed = state.m_61143_(PropertyHolder.CHEST_STATE) == ChestState.CLOSED || ClientUtils.OPTIFINE_LOADED.get() != false;
        this.latch = (LatchType)((Object)state.m_61143_(PropertyHolder.LATCH_TYPE));
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (Utils.isY(quad.m_111306_())) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.0625f, 0.0625f, 0.9375f, 0.9375f)) {
                if (topBotQuad.m_111306_() == Direction.UP) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, this.closed ? 0.875f : 0.625f);
                    quadMap.get(null).add(topBotQuad);
                } else {
                    quadMap.get(quad.m_111306_()).add(topBotQuad);
                }
            }
        } else {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.0625f, 0.0f, 0.9375f, this.closed ? 0.875f : 0.625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.9375f);
                quadMap.get(null).add(sideQuad);
            }
        }
        if (this.latch == LatchType.CAMO) {
            FramedChestModel.makeChestLatch(quadMap, quad, this.facing);
        }
    }

    public static void makeChestLatch(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction facing) {
        Direction face = quad.m_111306_();
        BakedQuad copy = ModelUtils.duplicateQuad(quad);
        if (face == facing || face == facing.m_122424_()) {
            if (BakedQuadTransformer.createSideQuad(copy, 0.4375f, 0.4375f, 0.5625f, 0.6875f)) {
                if (face == facing) {
                    quadMap.get(facing).add(copy);
                } else {
                    BakedQuadTransformer.setQuadPosInFacingDir(copy, 0.0625f);
                    quadMap.get(null).add(copy);
                }
            }
        } else if (Utils.isY(face)) {
            if (BakedQuadTransformer.createTopBottomQuad(copy, facing.m_122424_(), 0.0625f) && BakedQuadTransformer.createTopBottomQuad(copy, facing.m_122427_(), 0.5625f) && BakedQuadTransformer.createTopBottomQuad(copy, facing.m_122428_(), 0.5625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(copy, face == Direction.UP ? 0.6875f : 0.5625f);
                quadMap.get(null).add(copy);
            }
        } else if (BakedQuadTransformer.createSideQuad(copy, 0.0f, 0.4375f, 1.0f, 0.6875f) && BakedQuadTransformer.createVerticalSideQuad(copy, facing.m_122424_(), 0.0625f)) {
            BakedQuadTransformer.setQuadPosInFacingDir(copy, 0.5625f);
            quadMap.get(null).add(copy);
        }
    }

    @Override
    protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
        return this.latch == LatchType.DEFAULT && layer == RenderType.m_110463_();
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data, RenderType layer) {
        if (!this.closed || this.latch != LatchType.DEFAULT) {
            return;
        }
        List quads = this.baseModel.getQuads(state, null, rand, data);
        for (BakedQuad quad : quads) {
            if (!quad.m_173410_().m_118413_().equals((Object)TEXTURE)) continue;
            quadMap.get(null).add(quad);
        }
    }

    public static BlockState itemSource() {
        return ((Block)FBContent.blockFramedChest.get()).m_49966_();
    }
}

