/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedCornerSlopeModel
extends FramedBlockModel {
    private final Direction dir;
    private final CornerType type;

    public FramedCornerSlopeModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        this.type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        BakedQuad slopeQuad;
        if (this.type.isHorizontal()) {
            BakedQuad slopeQuad2;
            if (quad.m_111306_() == this.dir.m_122427_() && this.type.isRight() || quad.m_111306_() == this.dir.m_122428_() && !this.type.isRight()) {
                BakedQuad triQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideTriangleQuad(triQuad, this.type.isRight(), this.type.isTop())) {
                    quadMap.get(quad.m_111306_()).add(triQuad);
                }
            } else if (quad.m_111306_() == this.dir.m_122428_() && this.type.isRight() || quad.m_111306_() == this.dir.m_122427_() && !this.type.isRight()) {
                BakedQuad slopeQuad3 = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideTriangleQuad(slopeQuad3, !this.type.isRight(), this.type.isTop())) {
                    BakedQuadTransformer.createSideSlopeQuad(slopeQuad3, this.type.isRight());
                    quadMap.get(null).add(slopeQuad3);
                }
            } else if (quad.m_111306_() == Direction.UP && this.type.isTop() || quad.m_111306_() == Direction.DOWN && !this.type.isTop()) {
                BakedQuad triQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomTriangleQuad(triQuad, this.type.isRight() ? this.dir.m_122427_() : this.dir)) {
                    quadMap.get(quad.m_111306_()).add(triQuad);
                }
            } else if (quad.m_111306_() == this.dir.m_122424_() && BakedQuadTransformer.createSideTriangleQuad(slopeQuad2 = ModelUtils.duplicateQuad(quad), this.type.isRight(), !this.type.isTop())) {
                BakedQuadTransformer.createTopBottomSlopeQuad(slopeQuad2, !this.type.isTop());
                quadMap.get(null).add(slopeQuad2);
            }
        } else if (quad.m_111306_() == this.dir) {
            BakedQuad triQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideTriangleQuad(triQuad, true, this.type.isTop())) {
                quadMap.get(quad.m_111306_()).add(triQuad);
            }
        } else if (quad.m_111306_() == this.dir.m_122428_()) {
            BakedQuad triQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideTriangleQuad(triQuad, false, this.type.isTop())) {
                quadMap.get(quad.m_111306_()).add(triQuad);
            }
        } else if (quad.m_111306_() == this.dir.m_122424_()) {
            BakedQuad slopeQuad4 = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideTriangleQuad(slopeQuad4, false, this.type.isTop())) {
                BakedQuadTransformer.createTopBottomSlopeQuad(slopeQuad4, !this.type.isTop());
                quadMap.get(null).add(slopeQuad4);
            }
        } else if (quad.m_111306_() == this.dir.m_122427_() && BakedQuadTransformer.createSideTriangleQuad(slopeQuad = ModelUtils.duplicateQuad(quad), true, this.type.isTop())) {
            BakedQuadTransformer.createTopBottomSlopeQuad(slopeQuad, !this.type.isTop());
            quadMap.get(null).add(slopeQuad);
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedCornerSlope.get()).m_49966_().m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

