/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.api.util.client.TriangleDirection;
import xfacthd.framedblocks.common.FBContent;

public class FramedPrismModel
extends FramedBlockModel {
    private final Direction facing;
    private final Direction.Axis axis;

    public FramedPrismModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        this.axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
    }

    public FramedPrismModel(BakedModel baseModel) {
        this((BlockState)((Block)FBContent.blockFramedPrism.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP), baseModel);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (this.isStateInvalid()) {
            quadMap.get(quad.m_111306_()).add(quad);
            return;
        }
        Direction quadFace = quad.m_111306_();
        if (Utils.isY(this.facing) && quadFace.m_122434_() != this.axis && quadFace.m_122434_() != this.facing.m_122434_()) {
            BakedQuad slope = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(slope, this.facing == Direction.DOWN, 0.5f)) {
                BakedQuadTransformer.createTopBottomSlopeQuad(slope, this.facing == Direction.UP);
                quadMap.get(null).add(slope);
            }
        } else if (!Utils.isY(this.facing) && this.axis != Direction.Axis.Y && quadFace == this.facing) {
            BakedQuad slope = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(slope, false, 0.5f)) {
                BakedQuadTransformer.createTopBottomSlopeQuad(slope, false);
                quadMap.get(null).add(slope);
            }
            if (BakedQuadTransformer.createHorizontalSideQuad(slope = ModelUtils.duplicateQuad(quad), true, 0.5f)) {
                BakedQuadTransformer.createTopBottomSlopeQuad(slope, true);
                quadMap.get(null).add(slope);
            }
        } else if (!Utils.isY(this.facing) && this.axis == Direction.Axis.Y && quadFace.m_122434_() != this.axis && quadFace.m_122434_() != this.facing.m_122434_()) {
            BakedQuad slope = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createVerticalSideQuad(slope, this.facing, 0.5f)) {
                BakedQuadTransformer.createSideSlopeQuad(slope, quadFace == this.facing.m_122427_());
                quadMap.get(null).add(slope);
            }
        } else if (quadFace.m_122434_() == this.axis) {
            TriangleDirection triDir;
            if (Utils.isY(this.facing)) {
                triDir = this.facing == Direction.UP ? TriangleDirection.UP : TriangleDirection.DOWN;
            } else if (this.axis != Direction.Axis.Y) {
                triDir = quadFace == this.facing.m_122427_() ? TriangleDirection.RIGHT : TriangleDirection.LEFT;
            } else {
                BakedQuad triangle = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomSmallTriangleQuad(triangle, this.facing)) {
                    quadMap.get(quadFace).add(triangle);
                }
                return;
            }
            BakedQuad triangle = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSmallTriangleQuad(triangle, triDir)) {
                quadMap.get(quadFace).add(triangle);
            }
        }
    }

    private boolean isStateInvalid() {
        return this.axis == this.facing.m_122434_();
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedPrism.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP);
    }
}

