/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data;

import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;

public enum CornerType implements StringRepresentable
{
    BOTTOM,
    TOP,
    HORIZONTAL_BOTTOM_LEFT,
    HORIZONTAL_BOTTOM_RIGHT,
    HORIZONTAL_TOP_LEFT,
    HORIZONTAL_TOP_RIGHT;

    private final String name = this.toString().toLowerCase(Locale.ENGLISH);

    public String m_7912_() {
        return this.name;
    }

    public boolean isHorizontal() {
        return this != BOTTOM && this != TOP;
    }

    public boolean isTop() {
        return this == TOP || this == HORIZONTAL_TOP_LEFT || this == HORIZONTAL_TOP_RIGHT;
    }

    public boolean isRight() {
        return this == HORIZONTAL_BOTTOM_RIGHT || this == HORIZONTAL_TOP_RIGHT;
    }

    public CornerType verticalOpposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case TOP -> BOTTOM;
            case BOTTOM -> TOP;
            case HORIZONTAL_BOTTOM_RIGHT -> HORIZONTAL_TOP_RIGHT;
            case HORIZONTAL_BOTTOM_LEFT -> HORIZONTAL_TOP_LEFT;
            case HORIZONTAL_TOP_RIGHT -> HORIZONTAL_BOTTOM_RIGHT;
            case HORIZONTAL_TOP_LEFT -> HORIZONTAL_BOTTOM_LEFT;
        };
    }

    public boolean isHorizontalAdjacent(Direction dir, Direction side, CornerType adjType) {
        if (!this.isHorizontal() || !adjType.isHorizontal()) {
            return false;
        }
        switch (this) {
            case HORIZONTAL_TOP_LEFT: {
                if (side == Direction.UP) {
                    return adjType == HORIZONTAL_BOTTOM_LEFT;
                }
                if (side == dir.m_122428_()) {
                    return adjType == HORIZONTAL_TOP_RIGHT;
                }
                return false;
            }
            case HORIZONTAL_TOP_RIGHT: {
                if (side == Direction.UP) {
                    return adjType == HORIZONTAL_BOTTOM_RIGHT;
                }
                if (side == dir.m_122427_()) {
                    return adjType == HORIZONTAL_TOP_LEFT;
                }
                return false;
            }
            case HORIZONTAL_BOTTOM_LEFT: {
                if (side == Direction.DOWN) {
                    return adjType == HORIZONTAL_TOP_LEFT;
                }
                if (side == dir.m_122428_()) {
                    return adjType == HORIZONTAL_BOTTOM_RIGHT;
                }
                return false;
            }
            case HORIZONTAL_BOTTOM_RIGHT: {
                if (side == Direction.DOWN) {
                    return adjType == HORIZONTAL_TOP_RIGHT;
                }
                if (side == dir.m_122427_()) {
                    return adjType == HORIZONTAL_BOTTOM_LEFT;
                }
                return false;
            }
        }
        return false;
    }

    public boolean isHorizontalAdjacentInner(Direction dir, Direction side, CornerType adjType) {
        if (!this.isHorizontal() || !adjType.isHorizontal()) {
            return false;
        }
        switch (this) {
            case HORIZONTAL_BOTTOM_RIGHT: {
                if (side == Direction.UP) {
                    return adjType == HORIZONTAL_TOP_RIGHT;
                }
                if (side == dir.m_122428_()) {
                    return adjType == HORIZONTAL_BOTTOM_LEFT;
                }
                return false;
            }
            case HORIZONTAL_BOTTOM_LEFT: {
                if (side == Direction.UP) {
                    return adjType == HORIZONTAL_TOP_LEFT;
                }
                if (side == dir.m_122427_()) {
                    return adjType == HORIZONTAL_BOTTOM_RIGHT;
                }
                return false;
            }
            case HORIZONTAL_TOP_RIGHT: {
                if (side == Direction.DOWN) {
                    return adjType == HORIZONTAL_BOTTOM_RIGHT;
                }
                if (side == dir.m_122428_()) {
                    return adjType == HORIZONTAL_TOP_LEFT;
                }
                return false;
            }
            case HORIZONTAL_TOP_LEFT: {
                if (side == Direction.DOWN) {
                    return adjType == HORIZONTAL_BOTTOM_LEFT;
                }
                if (side == dir.m_122427_()) {
                    return adjType == HORIZONTAL_TOP_RIGHT;
                }
                return false;
            }
        }
        return false;
    }
}

