/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.util;

import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import xfacthd.framedblocks.common.block.FramedRailSlopeBlock;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;

public final class FramedUtils {
    public static Direction getBlockFacing(BlockState state) {
        if (state.m_60734_() instanceof FramedRailSlopeBlock) {
            return FramedRailSlopeBlock.directionFromShape((RailShape)state.m_61143_(PropertyHolder.ASCENDING_RAIL_SHAPE));
        }
        return (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
    }

    public static SlopeType getSlopeType(BlockState state) {
        if (state.m_60734_() instanceof FramedRailSlopeBlock) {
            return SlopeType.BOTTOM;
        }
        return (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
    }

    public static void enqueueImmediateTask(LevelAccessor level, Runnable task, boolean allowClient) {
        if (level.m_5776_() && allowClient) {
            task.run();
        } else {
            FramedUtils.enqueueTask(level, task, 0);
        }
    }

    public static void enqueueTask(LevelAccessor level, Runnable task, int delay) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalArgumentException("Utils#enqueueTask() called with a non-ServerWorld");
        }
        ServerLevel slevel = (ServerLevel)level;
        MinecraftServer server = slevel.m_142572_();
        server.m_6937_((Runnable)new TickTask(server.m_129921_() + delay, task));
    }

    private FramedUtils() {
    }
}

