/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core;

import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import shetiphian.core.common.network.PacketPlayerConfig;
import shetiphian.core.internal.Values;
import shetiphian.core.internal.network.NetworkHandler;

public class Configuration {
    private static final ForgeConfigSpec.Builder BUILDER_CLIENT = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder BUILDER_COMMON = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER_CLIENT, BUILDER_COMMON);
    public static final CoreEdits CORE_EDITS = new CoreEdits(BUILDER_CLIENT, BUILDER_COMMON);
    static final ForgeConfigSpec SPEC_CLIENT = BUILDER_CLIENT.build();
    static final ForgeConfigSpec SPEC_COMMON = BUILDER_COMMON.build();

    @SubscribeEvent
    public static void onReLoad(ModConfigEvent.Reloading event) {
        ModConfig config = event.getConfig();
        if (config.getType() == ModConfig.Type.CLIENT) {
            Configuration.sync();
        }
    }

    public static void sync() {
        if (NetworkHandler.isLoaded()) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().execute(() -> {
                try {
                    NetworkHandler.sendToServer(PacketPlayerConfig.sync(Values.keyConfigUseColorBlend, (Boolean)Configuration.GENERAL.useColorBlendMode.get()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
        }
    }

    public static class General {
        public ForgeConfigSpec.BooleanValue useColorBlendMode;
        public ForgeConfigSpec.BooleanValue keysChangeToolMode;

        General(ForgeConfigSpec.Builder client_builder, ForgeConfigSpec.Builder common_builder) {
            this.useColorBlendMode = client_builder.comment(new String[]{"Adjust the default way RGB16 handles dyes", "True = RYB blending is used to mix the colors", " > Like mixing paint, the dye will be added to the existing color", " > Sneak-Click to set to dye color", " ", "False = Direct RGB value manipulation", " > Click to increase, Sneak-Click to decrease", " ", "RYB is easier to use but RGB is more precise"}).define("use_color_blend_mode", true);
            this.keysChangeToolMode = client_builder.comment("In addition to Sneak+Scroll, Tool Modes can be changed with Sneak+PageUp/Down").define("keys_change_tool_mode", true);
        }
    }

    public static class CoreEdits {
        public ForgeConfigSpec.BooleanValue enableThinBlockHandler;
        public ForgeConfigSpec.BooleanValue enableCarpetPassthrough;
        public ForgeConfigSpec.BooleanValue bonemealRestoresBark;

        CoreEdits(ForgeConfigSpec.Builder client_builder, ForgeConfigSpec.Builder common_builder) {
            common_builder.comment("Core Edits").push("core_edits");
            this.enableThinBlockHandler = common_builder.comment(new String[]{"Modifies entity collision checks to work with thinner blocks", "Unmodified ignores blocks bellow 1/5 (slightly thicker then a lower trap door)", "Modified processes blocks down to 3/32 (slightly thicker then carpets)", "", "If you need to disable this to solve a compatibility issue, please report it to me", "Non-living entities and thinner blocks are already exempt to avoid compatibility issues"}).define("enable_thin_block_handler", true);
            this.enableCarpetPassthrough = common_builder.comment("When enabled carpets on top of scaffolding can be passed through just like snow").define("enable_carpet_passthrough", true);
            this.bonemealRestoresBark = common_builder.comment("When enabled using bonemeal on a stripped log restores the bark").define("bonemeal_restores_bark", true);
            common_builder.pop();
        }
    }
}

