/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import shetiphian.core.common.Function;

@OnlyIn(value=Dist.CLIENT)
public abstract class SoundHandler {
    private Minecraft mc = Minecraft.m_91087_();

    @SubscribeEvent
    public void playSound(PlaySoundEvent event) {
        SoundInstance sound;
        SoundSource category = event.getSound().m_8070_();
        if ((category == null || category == SoundSource.BLOCKS || category == SoundSource.NEUTRAL || category == SoundSource.HOSTILE) && (sound = event.getSound()).m_5891_() != null) {
            event.setSound(this.onPlaySound(sound, category, event.getName(), sound.m_7769_(), sound.m_7783_(), sound.m_7772_(), sound.m_7780_(), sound.m_7778_()));
        }
    }

    protected abstract SoundInstance onPlaySpecialSound(SoundInstance var1, SoundSource var2, String var3, float var4, float var5, int var6, int var7, int var8);

    protected abstract SoundInstance onPlayPlaceBreakSound(SoundInstance var1, SoundSource var2, String var3, float var4, float var5, int var6, int var7, int var8, BlockState var9);

    protected abstract SoundInstance onPlayWalkFallSound(SoundInstance var1, SoundSource var2, String var3, float var4, float var5, int var6, int var7, int var8, BlockState var9);

    private SoundInstance onPlaySound(SoundInstance sound, SoundSource category, String name, float volume, float pitch, double sx, double sy, double sz) {
        SoundInstance newSound;
        BlockState state;
        SoundInstance newSound2;
        int[] blockXZ = Function.getBlockXZ(sx, sz);
        int x = blockXZ[0];
        int z = blockXZ[1];
        int y = (int)sy;
        if (sy - (double)y > 0.0) {
            ++y;
        }
        if (!name.startsWith("dig") && !name.startsWith("step") && sound != (newSound2 = this.onPlaySpecialSound(sound, category, name, volume, pitch, x, y, z))) {
            return newSound2;
        }
        if (name.startsWith("dig")) {
            state = this.mc.f_91073_.m_8055_(new BlockPos(x, y, z));
            if (state.m_60734_() instanceof AirBlock) {
                state = this.mc.f_91073_.m_8055_(new BlockPos(x, y - 1, z));
            }
            if (sound != (newSound = this.onPlayPlaceBreakSound(sound, category, name, volume, pitch, x, y, z, state))) {
                return newSound;
            }
        }
        if (name.startsWith("step") && sound != (newSound = this.onPlayWalkFallSound(sound, category, name, volume, pitch, x, y, z, state = this.mc.f_91073_.m_8055_(new BlockPos(x, y - 1, z))))) {
            return newSound;
        }
        return sound;
    }

    protected SoundInstance getPlaceSound(SoundType sound, SoundSource category, float volume, float pitch, float x, float y, float z) {
        return this.getSound(sound.m_56777_().m_11660_(), category, volume, pitch, x, y, z);
    }

    protected SoundInstance getBreakSound(SoundType sound, SoundSource category, float volume, float pitch, float x, float y, float z) {
        return this.getSound(sound.m_56775_().m_11660_(), category, volume, pitch, x, y, z);
    }

    protected SoundInstance getStepSound(SoundType sound, SoundSource category, float volume, float pitch, float x, float y, float z) {
        return this.getSound(sound.m_56776_().m_11660_(), category, volume, pitch, x, y, z);
    }

    protected SoundInstance getSound(ResourceLocation soundId, SoundSource category, float volume, float pitch, float x, float y, float z) {
        return new SimpleSoundInstance(soundId, category, volume, pitch, false, 0, SoundInstance.Attenuation.LINEAR, (double)x, (double)y, (double)z, false);
    }
}

