/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt;

import com.google.gson.JsonElement;
import dev.gigaherz.toolbelt.BeltFinder;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class BeltFinderCurios
extends BeltFinder {
    public static void initCurios() {
        BeltFinder.addFinder(new BeltFinderCurios());
    }

    @Override
    public String getName() {
        return "curios";
    }

    @Override
    public Optional<? extends BeltFinder.BeltGetter> findStack(LivingEntity entity, boolean allowCosmetic) {
        return entity.getCapability(CuriosCapability.INVENTORY).resolve().flatMap(curios -> curios.getCurios().entrySet().stream().map(pair -> {
            Optional<? extends BeltFinder.BeltGetter> result;
            String slotName = (String)pair.getKey();
            ICurioStacksHandler handler = (ICurioStacksHandler)pair.getValue();
            if (allowCosmetic && (result = this.findBeltInInventory(entity, slotName, true, (IItemHandler)handler.getCosmeticStacks())).isPresent()) {
                return result;
            }
            return this.findBeltInInventory(entity, slotName, false, (IItemHandler)handler.getStacks());
        }).filter(Optional::isPresent).map(Optional::get).findFirst());
    }

    private Optional<? extends BeltFinder.BeltGetter> findBeltInInventory(LivingEntity entity, String slotName, boolean isCosmetic, IItemHandler inventory) {
        return this.findBeltInInventory(inventory, i -> new CuriosBeltGetter(entity, slotName, isCosmetic, i));
    }

    @Override
    protected Optional<BeltFinder.BeltGetter> getSlotFromId(Player entity, JsonElement slot) {
        return Optional.empty();
    }

    private static class CuriosBeltGetter
    implements BeltFinder.BeltGetter {
        private final LivingEntity entity;
        private final String slotKind;
        private final boolean isCosmeticSlot;
        private final int slotNumber;

        private CuriosBeltGetter(LivingEntity entity, String slotKind, boolean isCosmeticSlot, int slotNumber) {
            this.entity = entity;
            this.slotKind = slotKind;
            this.isCosmeticSlot = isCosmeticSlot;
            this.slotNumber = slotNumber;
        }

        private Optional<IDynamicStackHandler> getCuriosInventory() {
            return this.getCuriosHandler().map(handler -> this.isCosmeticSlot ? handler.getCosmeticStacks() : handler.getStacks());
        }

        private Optional<ICurioStacksHandler> getCuriosHandler() {
            return this.entity.getCapability(CuriosCapability.INVENTORY).resolve().flatMap(curios -> curios.getStacksHandler(this.slotKind));
        }

        @Override
        public ItemStack getBelt() {
            return this.getCuriosInventory().map(inventory -> inventory.getStackInSlot(this.slotNumber)).orElse(ItemStack.f_41583_);
        }

        @Override
        public void setBelt(ItemStack stack) {
            this.getCuriosInventory().ifPresent(inventory -> inventory.setStackInSlot(this.slotNumber, stack));
        }

        @Override
        public boolean isHidden() {
            return this.getCuriosHandler().map(handler -> handler.isVisible() && (Boolean)handler.getRenders().get(this.slotNumber) != false).orElse(true) == false;
        }

        @Override
        public void syncToClients() {
        }
    }
}

