/*
 * Decompiled with CFR 0.152.
 */
package fuzs.airhop;

import fuzs.airhop.config.ServerConfig;
import fuzs.airhop.handler.PlayerFallHandler;
import fuzs.airhop.handler.PlayerSyncHandler;
import fuzs.airhop.network.client.message.C2SAirHopMessage;
import fuzs.airhop.network.message.S2CSyncAirHopsMessage;
import fuzs.airhop.registry.ModRegistry;
import fuzs.puzzleslib.config.AbstractConfig;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.config.ConfigHolderImpl;
import fuzs.puzzleslib.network.MessageDirection;
import fuzs.puzzleslib.network.NetworkHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="airhop")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AirHop {
    public static final String MOD_ID = "airhop";
    public static final String MOD_NAME = "Air Hop";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Air Hop");
    public static final NetworkHandler NETWORK = NetworkHandler.of((String)"airhop");
    public static final ConfigHolder<AbstractConfig, ServerConfig> CONFIG = ConfigHolder.server(() -> new ServerConfig());

    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        ((ConfigHolderImpl)CONFIG).addConfigs(MOD_ID);
        ModRegistry.touch();
        AirHop.registerMessages();
        AirHop.registerHandlers();
    }

    private static void registerHandlers() {
        PlayerFallHandler playerFallHandler = new PlayerFallHandler();
        MinecraftForge.EVENT_BUS.addListener(playerFallHandler::onPlayerTick$start);
        MinecraftForge.EVENT_BUS.addListener(playerFallHandler::onLivingFall);
        PlayerSyncHandler playerSyncHandler = new PlayerSyncHandler();
        MinecraftForge.EVENT_BUS.addListener(playerSyncHandler::onEntityJoinWorld);
    }

    private static void registerMessages() {
        NETWORK.register(S2CSyncAirHopsMessage.class, S2CSyncAirHopsMessage::new, MessageDirection.TO_CLIENT);
        NETWORK.register(C2SAirHopMessage.class, C2SAirHopMessage::new, MessageDirection.TO_SERVER);
    }
}

