/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.loot;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EntityModifier
extends LootModifier {
    private final LootPool pool;
    private final Item item;
    private final int weight;
    private final int min;
    private final int max;

    protected EntityModifier(LootItemCondition[] conditionsIn, Item item, int weight, int min, int max) {
        super(conditionsIn);
        this.item = item;
        this.weight = weight;
        this.min = min;
        this.max = max;
        LootPool.Builder builder = LootPool.m_79043_();
        builder.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
        builder.m_165135_((NumberProvider)ConstantValue.m_165692_((float)0.0f));
        builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79707_(weight).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max), (boolean)false)));
        this.pool = builder.m_79082_();
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        this.pool.m_79053_(generatedLoot::add, context);
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<EntityModifier> {
        public EntityModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13851_((JsonObject)object, (String)"item", (String)"minecraft:air")));
            int weight = GsonHelper.m_13824_((JsonObject)object, (String)"weight", (int)1);
            int min = GsonHelper.m_13824_((JsonObject)object, (String)"min", (int)0);
            int max = GsonHelper.m_13824_((JsonObject)object, (String)"max", (int)1);
            return new EntityModifier(ailootcondition, item, weight, min, max);
        }

        public JsonObject write(EntityModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

