/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import top.theillusivec4.comforts.common.block.HammockBlock;
import top.theillusivec4.comforts.common.block.SleepingBagBlock;
import top.theillusivec4.comforts.common.capability.CapabilitySleepData;

public class ClientEventHandler {
    @SubscribeEvent
    public void onPostPlayerTick(TickEvent.PlayerTickEvent evt) {
        Player player;
        if (evt.phase == TickEvent.Phase.START && evt.side == LogicalSide.CLIENT && !(player = evt.player).m_5803_()) {
            CapabilitySleepData.getCapability(player).ifPresent(sleepdata -> {
                BlockPos pos = sleepdata.getAutoSleepPos();
                if (pos != null) {
                    Level world = player.f_19853_;
                    BlockState state = world.m_8055_(pos);
                    if (world.isAreaLoaded(pos, 1) && state.m_60734_() instanceof SleepingBagBlock) {
                        BlockHitResult hit = new BlockHitResult(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), player.m_6350_(), pos, false);
                        MultiPlayerGameMode playerController = Minecraft.m_91087_().f_91072_;
                        if (playerController != null) {
                            playerController.m_105262_((LocalPlayer)player, (ClientLevel)player.f_19853_, InteractionHand.MAIN_HAND, hit);
                        }
                    }
                    sleepdata.setAutoSleepPos(null);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerRenderPre(RenderPlayerEvent.Pre evt) {
        Player player = evt.getPlayer();
        if (player instanceof RemotePlayer && player.m_20089_() == Pose.SLEEPING) {
            player.m_21257_().ifPresent(bedPos -> {
                PoseStack matrixStack = evt.getPoseStack();
                Block bed = player.f_19853_.m_8055_(bedPos).m_60734_();
                if (bed instanceof SleepingBagBlock) {
                    matrixStack.m_85837_(0.0, -0.375, 0.0);
                } else if (bed instanceof HammockBlock) {
                    matrixStack.m_85837_(0.0, -0.5, 0.0);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerRenderPost(RenderPlayerEvent.Post evt) {
        Player player = evt.getPlayer();
        if (player instanceof RemotePlayer && player.m_20089_() == Pose.SLEEPING) {
            player.m_21257_().ifPresent(bedPos -> {
                PoseStack matrixStack = evt.getPoseStack();
                Block bed = player.f_19853_.m_8055_(bedPos).m_60734_();
                if (bed instanceof SleepingBagBlock) {
                    matrixStack.m_85837_(0.0, 0.375, 0.0);
                } else if (bed instanceof HammockBlock) {
                    matrixStack.m_85837_(0.0, 0.5, 0.0);
                }
            });
        }
    }
}

