/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.comforts.common.capability.CapabilitySleepData;

public class SPacketAutoSleep {
    private int entityId;
    private BlockPos pos;

    public SPacketAutoSleep(int entityIdIn, BlockPos posIn) {
        this.entityId = entityIdIn;
        this.pos = posIn;
    }

    public static void encode(SPacketAutoSleep msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.m_130064_(msg.pos);
    }

    public static SPacketAutoSleep decode(FriendlyByteBuf buf) {
        return new SPacketAutoSleep(buf.readInt(), buf.m_130135_());
    }

    public static void handle(SPacketAutoSleep msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(msg.entityId)) instanceof Player) {
                Player playerEntity = (Player)entity;
                CapabilitySleepData.getCapability(playerEntity).ifPresent(sleepdata -> sleepdata.setAutoSleepPos(msg.pos));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

