/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.comforts.data.ComfortsBlockLootTables;

public class ComfortsLootProvider
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> lootTables = ImmutableList.of((Object)Pair.of(ComfortsBlockLootTables::new, (Object)LootContextParamSets.f_81421_));

    public ComfortsLootProvider(DataGenerator generatorIn) {
        super(generatorIn);
        this.dataGenerator = generatorIn;
    }

    private static Path getPath(Path pathIn, ResourceLocation id) {
        return pathIn.resolve("data/" + id.m_135827_() + "/loot_tables/" + id.m_135815_() + ".json");
    }

    public void m_6865_(@Nonnull HashCache cache) {
        Path path = this.dataGenerator.m_123916_();
        HashMap map = Maps.newHashMap();
        this.lootTables.forEach(lootPair -> ((Consumer)((Supplier)lootPair.getFirst()).get()).accept((resourceLocation, lootTable) -> {
            if (map.put(resourceLocation, lootTable.m_79165_((LootContextParamSet)lootPair.getSecond()).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + resourceLocation);
            }
        }));
        ValidationContext validationtracker = new ValidationContext(LootContextParamSets.f_81420_, resourceLocation -> null, map::get);
        this.validate(map, validationtracker);
        Multimap multimap = validationtracker.m_79352_();
        if (!multimap.isEmpty()) {
            multimap.forEach((problemPath, problem) -> LOGGER.warn("Found validation problem in " + problemPath + ": " + problem));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        map.forEach((resourceLocation, lootTable) -> {
            Path path1 = ComfortsLootProvider.getPath(path, resourceLocation);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)lootTable), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save loot table {}", (Object)path1, (Object)ioexception);
            }
        });
    }

    @Nonnull
    public String m_6055_() {
        return "comfortsLootTables";
    }
}

