/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shetiphian.core.common.MyCreativeTab;
import shetiphian.core.common.RegistryHelper;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.gui.GuiPlatFormer;
import shetiphian.platforms.common.block.BlockPlatFormer;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.block.BlockPlatformFlat;
import shetiphian.platforms.common.block.BlockPlatformFloor;
import shetiphian.platforms.common.block.BlockPlatformFrame;
import shetiphian.platforms.common.block.BlockPlatformRail;
import shetiphian.platforms.common.block.BlockPlatformRamp;
import shetiphian.platforms.common.block.BlockPlatformRise;
import shetiphian.platforms.common.inventory.ContainerPlatFormer;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.item.ItemWrench;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.tileentity.TileEntityPlatFormer;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFlat;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFloor;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFrame;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRamp;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRise;

@Mod.EventBusSubscriber(modid="platforms", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Register {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        Values.blockPlatFormer = RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockPlatFormer(), (String)"platforms:platformer");
        Values.blocksPlatform.put(EnumPlatformType.FLAT, RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockPlatformFlat(), (String)"platforms:flat"));
        Values.blocksPlatform.put(EnumPlatformType.FLOOR, RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockPlatformFloor(), (String)"platforms:floor"));
        Values.blocksPlatform.put(EnumPlatformType.FRAME, RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockPlatformFrame(), (String)"platforms:frame"));
        Values.blocksPlatform.put(EnumPlatformType.RAMP, RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockPlatformRamp(), (String)"platforms:ramp"));
        Values.blocksPlatform.put(EnumPlatformType.RISE, RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockPlatformRise(), (String)"platforms:rise"));
        Values.blocksPlatform.put(EnumPlatformType.RAIL, RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockPlatformRail(), (String)"platforms:rail"));
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        Values.tilePlatFormer = RegistryHelper.register((IForgeRegistry)registry, TileEntityPlatFormer::new, (String)"platforms:platformer", (Block[])new Block[]{Values.blockPlatFormer});
        Values.tilePlatformFlat = RegistryHelper.register((IForgeRegistry)registry, TileEntityPlatformFlat::new, (String)"platforms:flat", (Block[])new Block[]{Values.blocksPlatform.get((Object)EnumPlatformType.FLAT)});
        Values.tilePlatformFloor = RegistryHelper.register((IForgeRegistry)registry, TileEntityPlatformFloor::new, (String)"platforms:floor", (Block[])new Block[]{Values.blocksPlatform.get((Object)EnumPlatformType.FLOOR)});
        Values.tilePlatformFrame = RegistryHelper.register((IForgeRegistry)registry, TileEntityPlatformFrame::new, (String)"platforms:frame", (Block[])new Block[]{Values.blocksPlatform.get((Object)EnumPlatformType.FRAME)});
        Values.tilePlatformRamp = RegistryHelper.register((IForgeRegistry)registry, TileEntityPlatformRamp::new, (String)"platforms:ramp", (Block[])new Block[]{Values.blocksPlatform.get((Object)EnumPlatformType.RAMP)});
        Block[] validBlocks = new Block[]{Values.blocksPlatform.get((Object)EnumPlatformType.RAIL), Values.blocksPlatform.get((Object)EnumPlatformType.RISE)};
        Values.tilePlatformRise = RegistryHelper.register((IForgeRegistry)registry, TileEntityPlatformRise::new, (String)"platforms:rise", (Block[])validBlocks);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Values.tabPlatforms = new MyCreativeTab("Platforms");
        RegistryHelper.register((IForgeRegistry)registry, (BlockItem)new BlockItem(Values.blockPlatFormer, Register.stackable()));
        for (Block block : Values.blocksPlatform.values()) {
            if (!(block instanceof BlockPlatformBase)) continue;
            EnumPlatformType style = ((BlockPlatformBase)block).getPlatformType();
            Values.itemsPlatform.put(style, (Item)RegistryHelper.register((IForgeRegistry)registry, (BlockItem)new ItemBlockPlatform(style, block, Register.stackable())));
        }
        RegistryHelper.register((IForgeRegistry)registry, (Item)new ItemWrench(Register.unstackable()), (String)"platforms:wrench");
        Register.setTabIcon();
    }

    private static Item.Properties stackable() {
        return new Item.Properties().m_41491_((CreativeModeTab)Values.tabPlatforms);
    }

    private static Item.Properties unstackable() {
        return Register.stackable().m_41487_(1);
    }

    private static void setTabIcon() {
        Values.tabPlatforms.setIcon(new ItemStack((ItemLike)Values.blockPlatFormer));
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((windowId, invPlayer, data) -> {
            BlockEntity tile = invPlayer.f_35978_.f_19853_.m_7702_(data.m_130135_());
            return tile instanceof TileEntityPlatFormer ? new ContainerPlatFormer(windowId, invPlayer, (TileEntityPlatFormer)tile) : null;
        }).setRegistryName("platforms:platformer")));
    }

    @OnlyIn(value=Dist.CLIENT)
    static void registerScreenFactories() {
        MenuScreens.m_96206_(Values.Container.PLATFORMER, GuiPlatFormer::new);
    }
}

