/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.model;

import com.google.common.collect.ImmutableMap;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import shetiphian.core.client.model.AbstractModelCacheBuilder;
import shetiphian.core.client.model.IPartData;
import shetiphian.platforms.Platforms;
import shetiphian.platforms.client.model.Parts;

@OnlyIn(value=Dist.CLIENT)
public class CacheBuilder
extends AbstractModelCacheBuilder {
    static CacheBuilder INSTANCE = new CacheBuilder(Platforms.LOGGER);

    public CacheBuilder(Logger logger) {
        super(logger);
    }

    static void rebuildCache() {
        INSTANCE.clearCache();
    }

    static void preload() {
        for (IPartData partData : Parts.MODELS) {
            CacheBuilder.INSTANCE.BAKERY.m_119341_(partData.getLocation());
        }
    }

    public void preBakeSetup(ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter) {
        super.preBakeSetup(bakery, spriteGetter);
        CacheBuilder.preload();
    }

    public static BakedModel get(String part, String key, Direction facing, String particle) {
        return INSTANCE.get(part, key, facing, particle, Parts.MODELS);
    }

    protected ImmutableMap<String, String> setTextures(IPartData partData, String texture, String particle) {
        if (partData.getName().contains("brazier_base")) {
            return new ImmutableMap.Builder().put((Object)"brazier", (Object)texture).put((Object)"particle", (Object)particle).build();
        }
        if (partData.getName().contains("brazier_fill")) {
            return new ImmutableMap.Builder().put((Object)"fill", (Object)texture).put((Object)"particle", (Object)particle).build();
        }
        return new ImmutableMap.Builder().put((Object)"texture", (Object)texture).put((Object)"particle", (Object)particle).build();
    }
}

