/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.block.PropertySubType;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;

public class BlockPlatformFloor
extends BlockPlatformBase {
    public static final PropertySubType SUBTYPE = PropertySubType.create("subtype", EnumSubType.getWalkwayValues());

    public BlockPlatformFloor() {
        super(EnumPlatformType.FLOOR);
    }

    @Override
    public PropertySubType getPropertySubType() {
        return SUBTYPE;
    }

    @Override
    protected VoxelShape buildShape(EnumSubType subType, Direction direction, EnumPlatformType railType, String linked, boolean collision) {
        if (!HITBOXES.isEmpty()) {
            VoxelShape[] parts = new VoxelShape[2];
            parts[0] = (VoxelShape)HITBOXES.get((Object)("floor_" + (collision ? "collide" : "select")), (Object)direction);
            if (railType != null) {
                parts[1] = (VoxelShape)HITBOXES.get((Object)(railType.m_7912_() + "_" + subType.getStyle() + (collision ? "_collide" : "_select")), (Object)direction);
            }
            return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])((VoxelShape[])Arrays.stream(parts).filter(Objects::nonNull).toArray(VoxelShape[]::new)));
        }
        return null;
    }

    static {
        BlockPlatformFloor.addHitBoxData("floor_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 16.0, 16.0}});
        BlockPlatformFloor.addHitBoxData("floor_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 16.0, 16.0}});
    }
}

