/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import net.minecraft.util.StringRepresentable;
import shetiphian.platforms.Configuration;

public enum EnumPlatformType implements StringRepresentable
{
    FLAT("flat", false),
    FLOOR("floor", false),
    FRAME("frame", false),
    RAMP("ramp", false),
    RISE("rise", true),
    RAIL("rail", true);

    private final String name;
    private final boolean addon;

    private EnumPlatformType(String name, boolean addon) {
        this.name = name;
        this.addon = addon;
    }

    public String m_7912_() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isAddon() {
        return this.addon;
    }

    public int getCraftAmount() {
        switch (this) {
            case FLAT: {
                return (Integer)Configuration.CRAFTING.baseFlat.get();
            }
            case FLOOR: {
                return (Integer)Configuration.CRAFTING.baseFloor.get();
            }
            case FRAME: {
                return (Integer)Configuration.CRAFTING.baseFrame.get();
            }
            case RAMP: {
                return (Integer)Configuration.CRAFTING.baseRamp.get();
            }
            case RISE: {
                return (Integer)Configuration.CRAFTING.baseRise.get();
            }
            case RAIL: {
                return (Integer)Configuration.CRAFTING.baseRail.get();
            }
        }
        return 1;
    }

    public static EnumPlatformType byName(String name) {
        for (EnumPlatformType entry : EnumPlatformType.values()) {
            if (!entry.m_7912_().equalsIgnoreCase(name)) continue;
            return entry;
        }
        return FLAT;
    }

    public static EnumPlatformType byIndex(int index) {
        EnumPlatformType[] values = EnumPlatformType.values();
        return index < 0 || index >= values.length ? FLAT : values[index];
    }
}

