/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFloor;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFrame;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRamp;

public class TileHelper {
    public static TileEntityPlatformBase getPlatformTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileEntityPlatformBase ? (TileEntityPlatformBase)tile : null;
    }

    public static boolean hasRail(TileEntityPlatformBase tile) {
        return tile != null && tile.hasRail();
    }

    public static EnumPlatformType getRail(TileEntityPlatformBase tile) {
        ItemStack rail;
        if (TileHelper.hasRail(tile) && !(rail = tile.getRailItem()).m_41619_() && rail.m_41720_() instanceof ItemBlockPlatform) {
            return ((ItemBlockPlatform)rail.m_41720_()).getPlatformType();
        }
        return null;
    }

    public static boolean setRail(TileEntityPlatformBase tile, ItemStack stack) {
        if (!stack.m_41619_()) {
            return tile.setRailItem(stack);
        }
        return false;
    }

    public static boolean removeRail(TileEntityPlatformBase tile) {
        if (TileHelper.hasRail(tile)) {
            tile.removeRail();
            return true;
        }
        return false;
    }

    public static boolean hasTorch(TileEntityPlatformBase tile) {
        return tile instanceof TileEntityPlatformFrame && ((TileEntityPlatformFrame)tile).getTorch() != EnumTorchType.NONE;
    }

    public static EnumTorchType getTorch(TileEntityPlatformBase tile) {
        return tile instanceof TileEntityPlatformFrame ? ((TileEntityPlatformFrame)tile).getTorch() : null;
    }

    public static boolean setTorch(TileEntityPlatformBase tile, EnumTorchType torchType) {
        return tile instanceof TileEntityPlatformFrame && ((TileEntityPlatformFrame)tile).setTorch(torchType);
    }

    public static boolean removeTorch(TileEntityPlatformBase tile) {
        if (TileHelper.hasTorch(tile)) {
            ((TileEntityPlatformFrame)tile).removeTorch();
            return true;
        }
        return false;
    }

    public static byte getAltSupport(TileEntityPlatformBase tile) {
        if (tile instanceof TileEntityPlatformRamp) {
            return ((TileEntityPlatformRamp)tile).getSupport();
        }
        if (tile instanceof TileEntityPlatformFloor) {
            return ((TileEntityPlatformFloor)tile).getSupport();
        }
        return 0;
    }

    public static void setAltSupport(TileEntityPlatformBase tile, int altSupport) {
        if (tile instanceof TileEntityPlatformRamp) {
            ((TileEntityPlatformRamp)tile).setSupport(altSupport);
        } else if (tile instanceof TileEntityPlatformFloor) {
            ((TileEntityPlatformFloor)tile).setSupport(altSupport);
        }
    }
}

