/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.client.gui.EntityGuiItem;
import shetiphian.core.common.Function;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.inventory.IOutputSlot;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.platforms.Configuration;
import shetiphian.platforms.Values;
import shetiphian.platforms.common.inventory.InventoryPlatFormer;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumPlatformType;

public class TileEntityPlatFormer
extends TileEntityBase
implements ISidedWrapper,
IOutputSlot {
    public InventoryInternal inventory;
    private final ISidedWrapper.SidedWrapper sidedWrapper;
    public EnumPlatformType platformType = EnumPlatformType.FLAT;
    private final ItemStack[] deconstructCache = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_};
    private EntityGuiItem displayItem = null;
    private ItemStack outputItem = ItemStack.f_41583_;

    public TileEntityPlatFormer(BlockPos pos, BlockState state) {
        super(Values.tilePlatFormer, pos, state);
        this.inventory = new InventoryPlatFormer(this);
        InventoryPlatFormer inv = (InventoryPlatFormer)this.inventory;
        this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapperBasic(), inv.getWrapperDeconstruct(), inv.getWrapperOutput(), inv.getWrapperStorage()});
        this.sidedWrapper.setFaceIndex(Direction.DOWN, 2);
        this.sidedWrapper.setFaceIndex(Direction.UP, 3);
        this.sidedWrapper.setFaceIndex(Direction.NORTH, 0);
        this.sidedWrapper.setFaceIndex(Direction.SOUTH, 0);
        this.sidedWrapper.setFaceIndex(Direction.WEST, 0);
        this.sidedWrapper.setFaceIndex(Direction.EAST, 0);
    }

    protected void buildNBT(CompoundTag nbtTag) {
        nbtTag.m_128359_("platform_type", this.platformType.m_7912_());
        this.inventory.writeToNBT(nbtTag, "items");
        this.sidedWrapper.writeToNBT(nbtTag);
    }

    protected void processNBT(CompoundTag nbtTag) {
        this.platformType = EnumPlatformType.byName(nbtTag.m_128461_("platform_type"));
        this.inventory.readFromNBT(nbtTag, nbtTag.m_128441_("items") ? "items" : "inventory");
        this.sidedWrapper.readFromNBT(nbtTag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            InvWrapper handler = this.sidedWrapper.getWrapper(Direction.SOUTH, facing);
            return handler == null ? LazyOptional.empty() : LazyOptional.of(() -> TileEntityPlatFormer.lambda$getCapability$0((IItemHandler)handler)).cast();
        }
        return super.getCapability(capability, facing);
    }

    public ISidedWrapper.SidedWrapper getSidedWrapper() {
        return this.sidedWrapper;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TileEntityPlatFormer tile) {
        ItemStack deconStack;
        if (tile.outputItem.m_41619_()) {
            tile.updateOutput();
        }
        if (!(deconStack = tile.inventory.m_8020_(5)).m_41619_()) {
            int needed = tile.getCraftedAmount(deconStack);
            if (deconStack.m_41613_() >= needed) {
                tile.deconstruct(needed);
            }
        }
    }

    private void deconstruct(int needed) {
        ItemStack deconStack = this.inventory.m_8020_(5);
        if (deconStack.m_41619_()) {
            return;
        }
        if (!Function.areItemStacksEqual((ItemStack)this.deconstructCache[0], (ItemStack)deconStack)) {
            this.deconstructCache[0] = deconStack;
            this.deconstructCache[1] = ItemBlockPlatform.getFrameTextureStack(deconStack);
            this.deconstructCache[2] = ItemBlockPlatform.getCoverTextureStack(deconStack);
        }
        if (this.deconstructCache[1].m_41619_() || this.deconstructCache[2].m_41619_()) {
            return;
        }
        int[] slots = new int[]{-1, -1};
        HashMap<Byte, ItemStack> changes = new HashMap<Byte, ItemStack>();
        block0: for (int item = 0; item < 2; item = (int)((byte)(item + 1))) {
            for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
                for (byte slot = 6; slot < 15; slot = (byte)((byte)(slot + 1))) {
                    ItemStack stack;
                    ItemStack itemStack = stack = changes.containsKey(slot) ? (ItemStack)changes.get(slot) : this.inventory.getContents()[slot];
                    if (!stack.m_41619_()) {
                        if (stack.m_41613_() >= stack.m_41741_() || !Function.areItemStacksEqual((ItemStack)stack, (ItemStack)this.deconstructCache[1 + item])) continue;
                        slots[item] = slot;
                        stack = stack.m_41777_();
                        stack.m_41769_(1);
                        changes.put(slot, stack);
                        continue block0;
                    }
                    if (pass != 1) continue;
                    slots[item] = slot;
                    changes.put(slot, this.deconstructCache[1 + item].m_41777_());
                    continue block0;
                }
            }
        }
        if (slots[0] > -1 && slots[1] > -1) {
            for (Map.Entry entry : changes.entrySet()) {
                this.inventory.getContents()[((Byte)entry.getKey()).byteValue()] = (ItemStack)entry.getValue();
            }
            if (deconStack.m_41613_() - needed < 1) {
                deconStack = ItemStack.f_41583_;
            } else {
                deconStack.m_41774_(needed);
            }
            this.inventory.m_6836_(5, deconStack);
            this.m_6596_();
        }
    }

    public void addExtraDrops(List<ItemStack> drops) {
        for (int slotId = 4; slotId < this.inventory.getContents().length; ++slotId) {
            ItemStack stack = this.inventory.m_8020_(slotId);
            if (stack.m_41619_()) continue;
            drops.add(stack);
        }
    }

    private int getCraftedAmount(ItemStack stack) {
        int multiplier = 0;
        if (this.isStorageBlock(ItemBlockPlatform.getFrameTextureStack(stack))) {
            ++multiplier;
        }
        if (this.isStorageBlock(ItemBlockPlatform.getCoverTextureStack(stack))) {
            ++multiplier;
        }
        multiplier = multiplier == 0 ? 1 : multiplier * (Integer)Configuration.CRAFTING.compressedMultiplier.get();
        return Mth.m_14045_((int)(this.platformType.getCraftAmount() * multiplier), (int)1, (int)stack.m_41741_());
    }

    private boolean isStorageBlock(ItemStack stack) {
        return !stack.m_41619_() && TagHelper.isItemInTag((ItemStack)stack, (String)"forge:storage_blocks");
    }

    public void updateOutput() {
        if (this.m_58904_() == null) {
            return;
        }
        this.setGhostSlot(0, this.inventory.m_8020_(0));
        this.setGhostSlot(1, this.inventory.m_8020_(1));
        this.outputItem = ItemBlockPlatform.createStack(Values.blocksPlatform.get((Object)this.platformType), this.inventory.m_8020_(1), this.inventory.m_8020_(0));
        if (!this.outputItem.m_41619_()) {
            this.outputItem.m_41764_(this.getCraftedAmount(this.outputItem));
            ItemStack displayStack = this.outputItem.m_41777_();
            displayStack.m_41764_(1);
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                this.displayItem = new EntityGuiItem(this.m_58904_(), 0.0, 0.0, 0.0, displayStack);
            });
            if (this.inventory.m_8020_(0).m_41619_() || this.inventory.m_8020_(1).m_41619_()) {
                this.inventory.m_6836_(3, ItemStack.f_41583_);
            } else {
                this.inventory.m_6836_(3, this.outputItem.m_41777_());
            }
        }
    }

    public EntityGuiItem getEntity() {
        if (this.displayItem == null) {
            this.updateOutput();
        }
        return this.displayItem;
    }

    public boolean canCraft() {
        ItemStack[] craftStacks = new ItemStack[]{this.inventory.m_8020_(0), this.inventory.m_8020_(1)};
        boolean[] hasItem = new boolean[]{false, false};
        for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
            ItemStack stack = this.inventory.m_8020_(slot);
            if (stack.m_41619_()) continue;
            if (!hasItem[0] && Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[0])) {
                hasItem[0] = true;
                if (hasItem[1] || !Function.areItemStacksEqual((ItemStack)craftStacks[0], (ItemStack)craftStacks[1]) || stack.m_41613_() <= 1) continue;
                hasItem[1] = true;
            }
            if (hasItem[1] || !Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[1])) continue;
            hasItem[1] = true;
        }
        return hasItem[0] && hasItem[1];
    }

    public void doCraft() {
        ItemStack[] craftStacks = new ItemStack[]{this.inventory.m_8020_(0), this.inventory.m_8020_(1)};
        boolean[] hasItem = new boolean[]{false, false};
        for (int slot = 6; slot < 15; slot = (int)((byte)(slot + 1))) {
            ItemStack stack = this.inventory.m_8020_(slot);
            if (stack.m_41619_()) continue;
            for (int part = 0; part < 2; part = (int)((byte)(part + 1))) {
                if (hasItem[part] || !Function.areItemStacksEqual((ItemStack)stack, (ItemStack)craftStacks[part])) continue;
                hasItem[part] = true;
                if (stack.m_41613_() == 1) {
                    this.inventory.m_6836_(slot, ItemStack.f_41583_);
                    continue;
                }
                stack.m_41774_(1);
                this.inventory.m_6836_(slot, stack);
            }
        }
    }

    public void setGhostSlot(int slotId, ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof BlockItem)) {
            if (slotId >= 0 && slotId < 3) {
                this.inventory.m_6836_(slotId, ItemStack.f_41583_);
            }
            return;
        }
        boolean itemOK = false;
        if ((slotId == 0 || slotId == 1) && stack.m_41720_() instanceof BlockItem) {
            BlockState state = UseContext.getBlockPlacementStateFor((ItemStack)stack, (Level)this.m_58904_());
            boolean bl = itemOK = !(((BlockItem)stack.m_41720_()).m_40614_() instanceof EntityBlock);
        }
        if (itemOK) {
            this.inventory.m_6836_(slotId, stack.m_41777_().m_41620_(1));
        } else {
            this.inventory.m_6836_(slotId, ItemStack.f_41583_);
        }
    }

    public boolean canTakeFromOutputSlot(int slotId, Player player) {
        return slotId != 3 || player.m_150110_().f_35937_ || this.canCraft();
    }

    public ItemStack shrinkStackSize(int slotId, Player player, int amount) {
        ItemStack stack;
        if (slotId == 3 && player.m_150110_().f_35937_ && !(stack = this.inventory.m_8020_(3)).m_41619_()) {
            stack = stack.m_41777_();
            stack.m_41764_(64);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void onPickupFromOutputSlot(int slotId, Player player, ItemStack stack) {
    }

    public ItemStack getOutputItem() {
        return this.outputItem != null ? this.outputItem.m_41777_() : ItemStack.f_41583_;
    }

    private static /* synthetic */ IItemHandler lambda$getCapability$0(IItemHandler handler) {
        return handler;
    }
}

