/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.network;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;

public class SmokePosMsg
extends ForgeNetMsg<SmokePosMsg> {
    public BlockPos pos;
    public float amount;
    public float intensity;
    public float scale;
    public ColorARGB color;

    public SmokePosMsg() {
    }

    public SmokePosMsg(BlockPos pos, Smoke smoke) {
        this.pos = pos;
        this.amount = smoke.getAmount();
        this.intensity = smoke.getIntensity();
        this.scale = smoke.getScale();
        this.color = smoke.getFirstColorOrDefault();
    }

    public SmokePosMsg create() {
        return new SmokePosMsg();
    }

    public void sendTo(Level level) {
        AdChimneys.getInstance().getConnection().sendToAllObservingChunk((Object)this, level.m_46745_(this.pos));
    }

    public void handle(Level level, Player player) {
        if (GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)this.pos)) {
            Smoke smoke = new Smoke(this.amount, this.intensity, this.scale, this.color);
            WorldData.getData((LevelAccessor)level).getSmokeLocations().putClientOutlet(this.pos, smoke);
        }
    }
}

