/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.particles;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.particles.AbstractSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RetroSmokeParticle {
    @OnlyIn(value=Dist.CLIENT)
    public static void generate(Level world, IWind wind, Smoke smoke, BlockPos pos, float factor) {
        world.m_46473_().m_6180_("generateRetroSmokeParticles");
        int smokeAmount = Math.round(smoke.getAmount() * factor);
        FloatBounds dyBounds = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.6f));
        FloatBounds dxzBounds = FloatBounds.between((Float)Float.valueOf(0.125f), (Float)Float.valueOf(0.875f)).reduce(Float.valueOf(smoke.getScale() / 10.0f));
        Data data = new Data(wind, smoke);
        for (int i = 0; i < smokeAmount; ++i) {
            double dx = dxzBounds.randomBetween().floatValue();
            double dy = dyBounds.randomBetween().floatValue();
            double dz = dxzBounds.randomBetween().floatValue();
            Vect3d smokePos = Vect3d.from((BlockPos)pos).move(dx, dy, dz);
            world.m_6493_((ParticleOptions)data, true, smokePos.x, smokePos.y, smokePos.z, 0.0, 0.0, 0.0);
        }
        world.m_46473_().m_7238_();
    }

    public static class Data
    extends AbstractSmokeParticle.Data {
        public Data(IWind wind, Smoke smoke) {
            super(wind, smoke);
        }

        public ParticleType<?> m_6012_() {
            return AdChimneys.getInstance().particles.retro.get();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Instance
    extends AbstractSmokeParticle.Instance {
        public Instance(ClientLevel world, IWind wind, Smoke smoke, Vect3d pos, Vect3d motion, float scale, SpriteSet sprite) {
            super(world, wind, smoke, pos, motion, scale, sprite);
            this.setMotion(this.getMotion().scale((double)0.1f).add(motion));
            this.f_107663_ *= 0.75f * scale;
            this.f_107225_ = (int)(8.0 / (Math.random() * 0.8 + 0.2));
            this.f_107225_ = (int)((float)this.f_107225_ * scale);
            this.f_107225_ = Math.max(this.f_107225_, 1);
            this.f_107226_ = -0.004f;
            this.setColor(smoke.pickColor());
        }

        public float m_5902_(float partialTicks) {
            return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + partialTicks) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
        }

        @Override
        public ParticleRenderType m_7556_() {
            return ParticleRenderType.f_107430_;
        }

        @Override
        public void updateAnimatedSprite() {
            this.m_108339_(this.animatedSprite);
        }

        public void m_108339_(SpriteSet animatedSprite) {
            int age = this.f_107224_ - this.ticksInChimney;
            int lifetime = this.f_107225_ - this.ticksInChimney;
            this.m_108337_(animatedSprite.m_5819_(age, lifetime));
        }

        @Override
        public void m_5989_() {
            super.m_5989_();
            this.f_107216_ *= 0.96;
            if (this.inChimney) {
                ++this.f_107224_;
                if (!this.f_107218_) {
                    ++this.f_107225_;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    extends AbstractSmokeParticle.Factory<Data> {
        public Factory(SpriteSet sprite) {
            super(sprite);
        }

        public Particle createParticle(Data data, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            double motionY = (double)data.smoke.getIntensity() / 10.0 * CommonMath.Random.between((double)0.5, (double)1.0);
            return new Instance(world, data.wind, data.smoke, Vect3d.from((double)x, (double)y, (double)z), Vect3d.from((double)0.0, (double)motionY, (double)0.0), data.smoke.getScale(), this.sprite);
        }
    }

    public static class Deserializer
    extends AbstractSmokeParticle.Deserializer<Data> {
        public Data fromCommand(ParticleType<Data> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new Data((IWind)Wind.NONE, Smoke.getNone());
        }

        public Data fromNetwork(ParticleType<Data> particleTypeIn, FriendlyByteBuf buffer) {
            return new Data((IWind)Wind.NONE, Smoke.getNone());
        }
    }
}

