/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLPaths;

public class ProfilingBlacklist {
    private static final String scanBlacklistName = "scan-blacklist.txt";
    private List<String> blacklist = new LinkedList<String>();

    public static File getScanBlacklistFile() {
        return FMLPaths.CONFIGDIR.get().resolve(scanBlacklistName).toFile();
    }

    public ProfilingBlacklist() {
        File scanBlacklistFile = ProfilingBlacklist.getScanBlacklistFile();
        if (scanBlacklistFile.exists()) {
            try {
                this.blacklist = Files.readAllLines(scanBlacklistFile.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean contains(BlockState blockState) {
        String blockString = blockState.toString();
        return this.blacklist.stream().anyMatch(blockString::startsWith);
    }
}

