/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.common;

import fionathemortal.betterbiomeblend.common.BlendChunk;
import fionathemortal.betterbiomeblend.common.ColorCaching;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;

public final class BlendCache {
    public final ReentrantLock lock = new ReentrantLock();
    public final Long2ObjectLinkedOpenHashMap<BlendChunk> hash;
    public final Stack<BlendChunk> freeStack;
    public final ArrayList<BlendChunk> generating;
    public final Long2ObjectOpenHashMap<BlendChunk> invalidationHash;
    public int invalidationCounter = 0;

    public BlendCache(int count) {
        this.hash = new Long2ObjectLinkedOpenHashMap(count);
        this.freeStack = new Stack();
        this.generating = new ArrayList();
        this.invalidationHash = new Long2ObjectOpenHashMap(count);
        for (int index = 0; index < count; ++index) {
            this.freeStack.add(new BlendChunk());
        }
    }

    public void releaseChunkWithoutLock(BlendChunk chunk) {
        int refCount = chunk.release();
        if (refCount == 0) {
            this.freeStack.push(chunk);
        }
    }

    public void releaseChunk(BlendChunk chunk) {
        int refCount = chunk.release();
        if (refCount == 0) {
            this.lock.lock();
            this.freeStack.push(chunk);
            this.lock.unlock();
        }
    }

    public void addToInvalidationHash(BlendChunk chunk) {
        BlendChunk otherChunk = (BlendChunk)this.invalidationHash.get(chunk.invalidationKey);
        if (otherChunk != null) {
            chunk.next = otherChunk.next;
            chunk.prev = otherChunk;
            if (otherChunk.next != null) {
                otherChunk.next.prev = chunk;
            }
            otherChunk.next = chunk;
        } else {
            this.invalidationHash.put(chunk.invalidationKey, (Object)chunk);
        }
    }

    public void removeFromInvalidationHash(BlendChunk chunk) {
        if (chunk.prev == null) {
            this.invalidationHash.remove(chunk.invalidationKey);
            if (chunk.next != null) {
                this.invalidationHash.put(chunk.invalidationKey, (Object)chunk.next);
            }
        }
        chunk.removeFromLinkedList();
    }

    public void invalidateAll() {
        this.lock.lock();
        ++this.invalidationCounter;
        for (BlendChunk chunk : this.hash.values()) {
            this.releaseChunkWithoutLock(chunk);
            chunk.prev = null;
            chunk.next = null;
            chunk.markAsInvalid();
        }
        this.hash.clear();
        this.invalidationHash.clear();
        this.lock.unlock();
    }

    public void invalidateChunk(int chunkX, int chunkZ) {
        this.lock.lock();
        ++this.invalidationCounter;
        for (int z = -1; z <= 1; ++z) {
            for (int x = -1; x <= 1; ++x) {
                BlendChunk first;
                long key = ColorCaching.getChunkKey(chunkX + x, 0, chunkZ + z, 0);
                BlendChunk current = first = (BlendChunk)this.invalidationHash.get(key);
                while (current != null) {
                    BlendChunk next = current.next;
                    this.hash.remove(current.key);
                    this.removeFromInvalidationHash(current);
                    this.releaseChunkWithoutLock(current);
                    current.markAsInvalid();
                    current = next;
                }
                ListIterator<BlendChunk> iterator = this.generating.listIterator();
                while (iterator.hasNext()) {
                    BlendChunk generatingChunk = iterator.next();
                    if (generatingChunk.invalidationKey != key) continue;
                    generatingChunk.markAsInvalid();
                    iterator.remove();
                }
            }
        }
        this.lock.unlock();
    }

    public BlendChunk getChunk(int chunkX, int chunkY, int chunkZ, int colorType) {
        long key = ColorCaching.getChunkKey(chunkX, chunkY, chunkZ, colorType);
        this.lock.lock();
        BlendChunk result = (BlendChunk)this.hash.getAndMoveToFirst(key);
        if (result != null) {
            result.acquire();
        }
        this.lock.unlock();
        return result;
    }

    public BlendChunk newChunk(int chunkX, int chunkY, int chunkZ, int colorType) {
        long key = ColorCaching.getChunkKey(chunkX, chunkY, chunkZ, colorType);
        this.lock.lock();
        BlendChunk result = null;
        if (!this.freeStack.empty()) {
            result = this.freeStack.pop();
        } else {
            while (true) {
                long lastKey = this.hash.lastLongKey();
                result = (BlendChunk)this.hash.removeLast();
                if (result.getReferenceCount() == 1) break;
                this.hash.putAndMoveToFirst(lastKey, (Object)result);
            }
            result.release();
            this.removeFromInvalidationHash(result);
        }
        long invalidationKey = ColorCaching.getChunkKey(chunkX, 0, chunkZ, 0);
        result.key = key;
        result.invalidationCounter = this.invalidationCounter;
        result.invalidationKey = invalidationKey;
        result.prev = null;
        result.next = null;
        result.acquire();
        this.generating.add(result);
        this.lock.unlock();
        return result;
    }

    public BlendChunk putChunk(BlendChunk chunk) {
        BlendChunk result = chunk;
        this.lock.lock();
        if (this.generating.remove(chunk)) {
            BlendChunk prev = (BlendChunk)this.hash.getAndMoveToFirst(chunk.key);
            if (prev == null) {
                this.hash.putAndMoveToFirst(chunk.key, (Object)chunk);
                this.addToInvalidationHash(chunk);
                chunk.acquire();
            } else {
                BlendChunk olderChunk;
                if (chunk.invalidationCounter >= prev.invalidationCounter) {
                    olderChunk = prev;
                    this.hash.put(chunk.key, (Object)chunk);
                    this.addToInvalidationHash(chunk);
                    this.removeFromInvalidationHash(olderChunk);
                    chunk.acquire();
                } else {
                    olderChunk = chunk;
                    result = prev;
                    result.acquire();
                }
                this.releaseChunkWithoutLock(olderChunk);
                olderChunk.markAsInvalid();
            }
        }
        this.lock.unlock();
        return result;
    }
}

