/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.common.cache;

import fionathemortal.betterbiomeblend.common.ColorBlending;
import fionathemortal.betterbiomeblend.common.cache.Slice;
import java.util.Arrays;

public final class ColorSlice
extends Slice {
    public byte[] data = new byte[192];

    @Override
    public void invalidateRegion(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int cacheDim = 4;
        for (int y1 = minY; y1 < maxY; ++y1) {
            for (int z1 = minZ; z1 < maxZ; ++z1) {
                for (int x1 = minX; x1 < maxX; ++x1) {
                    int cacheIndex = ColorBlending.getCacheArrayIndex(cacheDim, x1, y1, z1);
                    this.data[3 * cacheIndex + 0] = -1;
                    this.data[3 * cacheIndex + 1] = -1;
                    this.data[3 * cacheIndex + 2] = -1;
                }
            }
        }
    }

    @Override
    public void invalidateData() {
        Arrays.fill(this.data, (byte)-1);
    }
}

