/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.data;

import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public abstract class LightDataAccess {
    protected static final FluidState EMPTY_FLUID_STATE = Fluids.f_76191_.m_76145_();
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    protected BlockAndTintGetter world;

    public long get(int x, int y, int z, Direction d1, Direction d2) {
        return this.get(x + d1.m_122429_() + d2.m_122429_(), y + d1.m_122430_() + d2.m_122430_(), z + d1.m_122431_() + d2.m_122431_());
    }

    public long get(int x, int y, int z, Direction dir) {
        return this.get(x + dir.m_122429_(), y + dir.m_122430_(), z + dir.m_122431_());
    }

    public long get(BlockPos pos, Direction dir) {
        return this.get(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), dir);
    }

    public long get(BlockPos pos) {
        return this.get(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public abstract long get(int var1, int var2, int var3);

    protected long compute(int x, int y, int z) {
        BlockAndTintGetter world = this.world;
        BlockPos.MutableBlockPos pos = this.pos.m_122178_(x, y, z);
        BlockState state = world.m_8055_((BlockPos)pos);
        float ao = state.m_60791_() == 0 ? state.m_60792_((BlockGetter)world, (BlockPos)pos) : 1.0f;
        boolean op = state.m_60819_() != EMPTY_FLUID_STATE || state.m_60739_((BlockGetter)world, (BlockPos)pos) == 0;
        boolean fo = state.m_60804_((BlockGetter)world, (BlockPos)pos);
        boolean em = state.m_60788_((BlockGetter)world, (BlockPos)pos);
        int lm = fo && !em ? 0 : LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)state, (BlockPos)pos);
        return LightDataAccess.packAO(ao) | LightDataAccess.packLM(lm) | LightDataAccess.packOP(op) | LightDataAccess.packFO(fo) | 0x1000000000000000L;
    }

    public static long packOP(boolean opaque) {
        return (opaque ? 1L : 0L) << 56;
    }

    public static boolean unpackOP(long word) {
        return (word >>> 56 & 1L) != 0L;
    }

    public static long packFO(boolean opaque) {
        return (opaque ? 1L : 0L) << 57;
    }

    public static boolean unpackFO(long word) {
        return (word >>> 57 & 1L) != 0L;
    }

    public static long packLM(int lm) {
        return (long)lm & 0xFFFFFFFFL;
    }

    public static int unpackLM(long word) {
        return (int)(word & 0xFFFFFFFFL);
    }

    public static long packAO(float ao) {
        int aoi = (int)(ao * 4096.0f);
        return ((long)aoi & 0xFFFFL) << 32;
    }

    public static float unpackAO(long word) {
        int aoi = (int)(word >>> 32 & 0xFFFFL);
        return (float)aoi * 2.4414062E-4f;
    }

    public BlockAndTintGetter getWorld() {
        return this.world;
    }
}

