/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline;

import java.util.List;
import java.util.Random;
import me.jellysquid.mods.sodium.client.model.IndexBufferBuilder;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorBlender;
import me.jellysquid.mods.sodium.client.model.quad.blender.ColorSampler;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadWinding;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.rand.XoRoShiRoRandom;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorsExtended;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.IModelData;

public class BlockRenderer {
    private final Random random = new XoRoShiRoRandom();
    private final BlockColorsExtended blockColors;
    private final BlockOcclusionCache occlusionCache;
    private final QuadLightData cachedQuadLightData = new QuadLightData();
    private final ColorBlender colorBlender;
    private final LightPipelineProvider lighters;
    private final boolean useAmbientOcclusion;

    public BlockRenderer(Minecraft client, LightPipelineProvider lighters, ColorBlender colorBlender) {
        this.blockColors = (BlockColorsExtended)client.m_91298_();
        this.colorBlender = colorBlender;
        this.lighters = lighters;
        this.occlusionCache = new BlockOcclusionCache();
        this.useAmbientOcclusion = Minecraft.m_91086_();
    }

    public boolean renderModel(BlockAndTintGetter world, BlockState state, BlockPos pos, BlockPos origin, BakedModel model, ChunkModelBuilder buffers, boolean cull, long seed, IModelData modelData) {
        LightPipeline lighter = this.lighters.getLighter(this.getLightingMode(state, model));
        Vec3 offset = state.m_60824_((BlockGetter)world, pos);
        modelData = model.getModelData(world, pos, state, modelData);
        boolean rendered = false;
        for (Direction dir : DirectionUtil.ALL_DIRECTIONS) {
            this.random.setSeed(seed);
            List sided = model.getQuads(state, dir, this.random, modelData);
            if (sided.isEmpty() || cull && !this.occlusionCache.shouldDrawSide(state, (BlockGetter)world, pos, dir)) continue;
            this.renderQuadList(world, state, pos, origin, lighter, offset, buffers, sided, ModelQuadFacing.fromDirection(dir));
            rendered = true;
        }
        this.random.setSeed(seed);
        List all = model.getQuads(state, null, this.random, modelData);
        if (!all.isEmpty()) {
            this.renderQuadList(world, state, pos, origin, lighter, offset, buffers, all, ModelQuadFacing.UNASSIGNED);
            rendered = true;
        }
        return rendered;
    }

    private void renderQuadList(BlockAndTintGetter world, BlockState state, BlockPos pos, BlockPos origin, LightPipeline lighter, Vec3 offset, ChunkModelBuilder buffers, List<BakedQuad> quads, ModelQuadFacing facing) {
        ColorSampler<BlockState> colorizer = null;
        ModelVertexSink vertices = buffers.getVertexSink();
        vertices.ensureCapacity(quads.size() * 4);
        IndexBufferBuilder indices = buffers.getIndexBufferBuilder(facing);
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            BakedQuad quad = quads.get(i);
            QuadLightData light = this.cachedQuadLightData;
            lighter.calculate((ModelQuadView)quad, pos, light, quad.m_111306_(), quad.m_111307_());
            if (quad.m_111304_() && colorizer == null) {
                colorizer = this.blockColors.getColorProvider(state);
            }
            this.renderQuad(world, state, pos, origin, vertices, indices, offset, colorizer, quad, light, buffers);
        }
        vertices.flush();
    }

    private void renderQuad(BlockAndTintGetter world, BlockState state, BlockPos pos, BlockPos origin, ModelVertexSink vertices, IndexBufferBuilder indices, Vec3 blockOffset, ColorSampler<BlockState> colorSampler, BakedQuad bakedQuad, QuadLightData light, ChunkModelBuilder model) {
        ModelQuadView src = (ModelQuadView)bakedQuad;
        ModelQuadOrientation orientation = ModelQuadOrientation.orientByBrightness(light.br);
        int[] colors = null;
        if (bakedQuad.m_111304_()) {
            colors = this.colorBlender.getColors(world, pos, src, colorSampler, state);
        }
        int vertexStart = vertices.getVertexCount();
        for (int i = 0; i < 4; ++i) {
            int j = orientation.getVertexIndex(i);
            float x = src.getX(j) + (float)blockOffset.m_7096_();
            float y = src.getY(j) + (float)blockOffset.m_7098_();
            float z = src.getZ(j) + (float)blockOffset.m_7094_();
            int color = ColorABGR.mul(colors != null ? colors[j] : src.getColor(j), light.br[j]);
            float u = src.getTexU(j);
            float v = src.getTexV(j);
            int lm = light.lm[j];
            vertices.writeVertex((Vec3i)origin, x, y, z, color, u, v, lm, model.getChunkId());
        }
        indices.add(vertexStart, ModelQuadWinding.CLOCKWISE);
        TextureAtlasSprite sprite = src.getSprite();
        if (sprite != null) {
            model.addSprite(sprite);
        }
    }

    private LightMode getLightingMode(BlockState state, BakedModel model) {
        if (this.useAmbientOcclusion && model.m_7541_() && state.m_60791_() == 0) {
            return LightMode.SMOOTH;
        }
        return LightMode.FLAT;
    }
}

