/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import me.jellysquid.mods.sodium.client.world.BiomeSeedProvider;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorCache;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import me.jellysquid.mods.sodium.client.world.cloned.PackedIntegerArrayExtended;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPalette;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;

public class WorldSlice
implements BlockAndTintGetter {
    private static final int SECTION_BLOCK_COUNT = 4096;
    private static final int SECTION_BIOME_COUNT = 64;
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private static final int NEIGHBOR_CHUNK_RADIUS = Mth.m_144941_((int)2, (int)16) >> 4;
    private static final int SECTION_LENGTH = 1 + NEIGHBOR_CHUNK_RADIUS * 2;
    private static final int TABLE_LENGTH = Mth.m_14125_((int)SECTION_LENGTH);
    private static final int TABLE_BITS = Integer.bitCount(TABLE_LENGTH - 1);
    private static final int BLOCK_BITS = 4;
    private static final int BIOME_BITS = 2;
    private static final int SECTION_TABLE_ARRAY_SIZE = TABLE_LENGTH * TABLE_LENGTH * TABLE_LENGTH;
    private final Level world;
    private final BiomeManager biomeAccess;
    private final BlockState[][] blockStatesArrays;
    private final Holder<Biome>[][] biomeArrays;
    private ClonedChunkSection[] sections;
    private BlockColorCache biomeColors;
    private int baseX;
    private int baseY;
    private int baseZ;
    private SectionPos origin;

    public static ChunkRenderContext prepare(Level world, SectionPos origin, ClonedChunkSectionCache sectionCache) {
        LevelChunk chunk = world.m_6325_(origin.m_123341_(), origin.m_123343_());
        LevelChunkSection section = chunk.m_7103_()[world.m_151566_(origin.m_123342_())];
        if (section == null || section.m_188008_()) {
            return null;
        }
        BoundingBox volume = new BoundingBox(origin.m_123229_() - 2, origin.m_123234_() - 2, origin.m_123239_() - 2, origin.m_123244_() + 2, origin.m_123247_() + 2, origin.m_123248_() + 2);
        int minChunkX = origin.m_123341_() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkY = origin.m_123342_() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkZ = origin.m_123343_() - NEIGHBOR_CHUNK_RADIUS;
        int maxChunkX = origin.m_123341_() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkY = origin.m_123342_() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkZ = origin.m_123343_() + NEIGHBOR_CHUNK_RADIUS;
        ClonedChunkSection[] sections = new ClonedChunkSection[SECTION_TABLE_ARRAY_SIZE];
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    sections[WorldSlice.getLocalSectionIndex((int)(chunkX - minChunkX), (int)(chunkY - minChunkY), (int)(chunkZ - minChunkZ))] = sectionCache.acquire(chunkX, chunkY, chunkZ);
                }
            }
        }
        return new ChunkRenderContext(origin, sections, volume);
    }

    public WorldSlice(Level world) {
        this.world = world;
        this.biomeAccess = new BiomeManager(this::getStoredBiome, ((BiomeSeedProvider)this.world).getBiomeSeed());
        this.sections = new ClonedChunkSection[SECTION_TABLE_ARRAY_SIZE];
        this.blockStatesArrays = new BlockState[SECTION_TABLE_ARRAY_SIZE][4096];
        this.biomeArrays = new Holder[SECTION_TABLE_ARRAY_SIZE][64];
    }

    public void copyData(ChunkRenderContext context) {
        this.origin = context.getOrigin();
        this.sections = context.getSections();
        this.baseX = this.origin.m_123341_() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.baseY = this.origin.m_123342_() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.baseZ = this.origin.m_123343_() - NEIGHBOR_CHUNK_RADIUS << 4;
        for (int x = 0; x < SECTION_LENGTH; ++x) {
            for (int y = 0; y < SECTION_LENGTH; ++y) {
                for (int z = 0; z < SECTION_LENGTH; ++z) {
                    int idx = WorldSlice.getLocalSectionIndex(x, y, z);
                    this.unpackBlockData(this.blockStatesArrays[idx], this.sections[idx], context.getVolume());
                    this.unpackBiomeData(this.biomeArrays[idx], this.sections[idx]);
                }
            }
        }
        this.biomeColors = new BlockColorCache(this, Minecraft.m_91087_().f_91066_.f_92032_);
    }

    private void unpackBlockData(BlockState[] states, ClonedChunkSection section, BoundingBox box) {
        if (this.origin.equals((Object)section.getPosition())) {
            this.unpackBlockData(states, section);
        } else {
            this.unpackBlockDataSlow(states, section, box);
        }
    }

    private void unpackBlockDataSlow(BlockState[] states, ClonedChunkSection section, BoundingBox box) {
        SimpleBitStorage intArray = section.getBlockData();
        ClonedPalette<BlockState> palette = section.getBlockPalette();
        SectionPos pos = section.getPosition();
        int minBlockX = Math.max(box.m_162395_(), pos.m_123229_());
        int maxBlockX = Math.min(box.m_162399_(), pos.m_123244_());
        int minBlockY = Math.max(box.m_162396_(), pos.m_123234_());
        int maxBlockY = Math.min(box.m_162400_(), pos.m_123247_());
        int minBlockZ = Math.max(box.m_162398_(), pos.m_123239_());
        int maxBlockZ = Math.min(box.m_162401_(), pos.m_123248_());
        for (int y = minBlockY; y <= maxBlockY; ++y) {
            for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                for (int x = minBlockX; x <= maxBlockX; ++x) {
                    int blockIdx = WorldSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF);
                    int value = intArray.m_13514_(blockIdx);
                    states[blockIdx] = palette.get(value);
                }
            }
        }
    }

    private void unpackBlockData(BlockState[] states, ClonedChunkSection section) {
        ((PackedIntegerArrayExtended)section.getBlockData()).copyUsingPalette(states, section.getBlockPalette());
    }

    private void unpackBiomeData(Holder<Biome>[] biomes, ClonedChunkSection section) {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    biomes[WorldSlice.getLocalBiomeIndex((int)x, (int)y, (int)z)] = section.getBiome(x, y, z);
                }
            }
        }
    }

    public BlockState m_8055_(BlockPos pos) {
        return this.getBlockState(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public BlockState getBlockState(int x, int y, int z) {
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.blockStatesArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)][WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF)];
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    public float m_7717_(Direction direction, boolean shaded) {
        return this.world.m_7717_(direction, shaded);
    }

    public LevelLightEngine m_5518_() {
        return this.world.m_5518_();
    }

    public BlockEntity m_7702_(BlockPos pos) {
        return this.getBlockEntity(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public BlockEntity getBlockEntity(int x, int y, int z) {
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.sections[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)].getBlockEntity(relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public int m_6171_(BlockPos pos, ColorResolver resolver) {
        return this.biomeColors.getColor(resolver, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public int m_45517_(LightLayer type, BlockPos pos) {
        int relX = pos.m_123341_() - this.baseX;
        int relY = pos.m_123342_() - this.baseY;
        int relZ = pos.m_123343_() - this.baseZ;
        return this.sections[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)].getLightLevel(type, relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public SectionPos getOrigin() {
        return this.origin;
    }

    public int m_141928_() {
        return this.world.m_141928_();
    }

    public int m_141937_() {
        return this.world.m_141937_();
    }

    private Holder<Biome> getStoredBiome(int biomeX, int biomeY, int biomeZ) {
        int chunkX = QuartPos.m_175402_((int)biomeX) - this.baseX >> 4;
        int chunkY = QuartPos.m_175402_((int)biomeY) - this.baseY >> 4;
        int chunkZ = QuartPos.m_175402_((int)biomeZ) - this.baseZ >> 4;
        return this.biomeArrays[WorldSlice.getLocalSectionIndex(chunkX, chunkY, chunkZ)][WorldSlice.getLocalBiomeIndex(biomeX & 3, biomeY & 3, biomeZ & 3)];
    }

    public BiomeManager getBiomeAccess() {
        return this.biomeAccess;
    }

    private static int getLocalBiomeIndex(int x, int y, int z) {
        return y << 2 << 2 | z << 2 | x;
    }

    public static int getLocalBlockIndex(int x, int y, int z) {
        return y << 4 << 4 | z << 4 | x;
    }

    public static int getLocalSectionIndex(int x, int y, int z) {
        return y << TABLE_BITS << TABLE_BITS | z << TABLE_BITS | x;
    }
}

