/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.eclectic.items;

import com.hyperlynx.eclectic.Registration;
import com.hyperlynx.eclectic.util.ConfigMan;
import com.hyperlynx.eclectic.util.Helper;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Pointer
extends Item {
    int RANGE = 64;
    double BLINDNESS_ANGLE = 0.19634954631328583;

    public Pointer(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        player.m_6672_(usedHand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(usedHand));
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity user, @NotNull ItemStack stack, int remainingUseDuration) {
        block5: {
            Vec3 laserPos;
            EntityHitResult entityHit;
            Vec3 start;
            Vec3 blockHitPos;
            int cat_range;
            block6: {
                Vec3 end;
                cat_range = (Integer)ConfigMan.COMMON.laserCatRange.get();
                if (!(user instanceof Player)) break block5;
                Player player = (Player)user;
                BlockHitResult blockHit = Helper.playerRayTrace(level, player, ClipContext.Fluid.NONE, ClipContext.Block.VISUAL, this.RANGE);
                blockHitPos = blockHit.m_82450_();
                start = player.m_146892_();
                entityHit = ProjectileUtil.m_37287_((Entity)player, (Vec3)start, (Vec3)(end = start.m_82549_(player.m_20154_().m_82490_((double)this.RANGE))), (AABB)new AABB(start, end), e -> e instanceof LivingEntity, (double)Double.MAX_VALUE);
                laserPos = entityHit == null ? blockHitPos : (entityHit.m_82450_().m_82557_(start) < blockHitPos.m_82557_(start) ? entityHit.m_82450_() : blockHitPos);
                if (!level.m_5776_()) break block6;
                for (int i = 0; i < 5; ++i) {
                    level.m_7106_((ParticleOptions)Registration.LASER_PARTICLE, laserPos.f_82479_, laserPos.f_82480_, laserPos.f_82481_, 0.0, 0.0, 0.0);
                }
                break block5;
            }
            if (!(user instanceof ServerPlayer)) break block5;
            ServerPlayer splayer = (ServerPlayer)user;
            if (entityHit != null) {
                LivingEntity target = (LivingEntity)entityHit.m_82443_();
                Vec3 targetEyes = target.m_146892_();
                Vec3 perfectHit = targetEyes.m_82546_(start).m_82541_();
                double hitDeltaTh = Pointer.angleBetween(perfectHit, splayer.m_20154_());
                double targetLookDeltaTh = Pointer.angleBetween(perfectHit, target.m_20154_());
                if (((Boolean)ConfigMan.COMMON.laserBlindness.get()).booleanValue() && !(target instanceof Ocelot) && !(target instanceof Cat) && !(target instanceof EnderMan) && !(target instanceof EnderDragon) && !(target instanceof WitherBoss) && hitDeltaTh <= this.BLINDNESS_ANGLE && targetLookDeltaTh >= 1.5707963705062866) {
                    MobEffectInstance blindness = new MobEffectInstance(MobEffects.f_19610_, 5, 0);
                    target.m_7292_(blindness);
                }
            }
            if ((Integer)ConfigMan.COMMON.laserCatRange.get() > 0) {
                AABB catAABB = new AABB(blockHitPos.m_82492_((double)cat_range, (double)cat_range, (double)cat_range), blockHitPos.m_82520_((double)cat_range, (double)cat_range, (double)cat_range));
                List cats = level.m_6249_((Entity)null, catAABB, e -> (e instanceof Ocelot || e instanceof Cat) && e.m_20238_(laserPos) <= (double)(cat_range * cat_range));
                for (Entity e2 : cats) {
                    PathfinderMob cat = (PathfinderMob)e2;
                    if (cat.m_21023_(MobEffects.f_19610_)) continue;
                    cat.m_21573_().m_26519_(laserPos.f_82479_, laserPos.f_82480_, laserPos.f_82481_, 1.2);
                    cat.m_7618_(EntityAnchorArgument.Anchor.EYES, laserPos);
                }
            }
        }
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.NONE;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return Integer.MAX_VALUE;
    }

    private static double angleBetween(Vec3 a, Vec3 b) {
        return Math.acos(a.m_82526_(b) / (a.m_82553_() * b.m_82553_()));
    }
}

