/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.render.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import com.mojang.math.Vector3f;
import eutros.framedcompactdrawers.render.model.FrameableModel;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.LowerCaseEnumTypeAdapterFactory;
import net.minecraftforge.client.model.IModelLoader;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FrameableModelLoader
implements IModelLoader<FrameableModel> {
    private static final Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory()).registerTypeAdapter(Multimap.class, (json, typeOfT, context) -> {
        Object valueType;
        Object keyType;
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Not an object: " + json);
        }
        JsonObject obj = json.getAsJsonObject();
        HashMultimap map = HashMultimap.create();
        if (typeOfT instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)typeOfT).getActualTypeArguments();
            keyType = typeArguments[0];
            valueType = typeArguments[1];
        } else {
            valueType = Object.class;
            keyType = Object.class;
        }
        for (Map.Entry entry : obj.entrySet()) {
            Object key = context.deserialize((JsonElement)new JsonPrimitive((String)entry.getKey()), (Type)keyType);
            if (!((JsonElement)entry.getValue()).isJsonArray()) {
                throw new JsonSyntaxException("Not an array: " + ((JsonElement)entry.getValue()).toString());
            }
            List values = StreamSupport.stream(((JsonElement)entry.getValue()).getAsJsonArray().spliterator(), false).map(arg_0 -> FrameableModelLoader.lambda$static$0(context, (Type)valueType, arg_0)).collect(Collectors.toList());
            map.putAll(key, values);
        }
        return map;
    }).registerTypeAdapter(Vector3f.class, (json, typeOfT, context) -> {
        if (!json.isJsonArray()) {
            throw new JsonSyntaxException("Not an array: " + json);
        }
        JsonArray array = json.getAsJsonArray();
        if (array.size() != 3) {
            throw new JsonSyntaxException("3D vector doesn't have 3 elements.");
        }
        return new Vector3f(StreamSupport.stream(array.spliterator(), false).mapToDouble(el -> {
            if (!el.isJsonPrimitive() || !el.getAsJsonPrimitive().isNumber()) {
                throw new JsonSyntaxException("Not a number: " + json);
            }
            return el.getAsDouble();
        }).collect(FloatArrayList::new, (fl, value) -> fl.add((float)value), FloatList::addAll).toFloatArray());
    }).registerTypeAdapter(BlockElementFace.class, (Object)new BlockElementFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(FrameableModel.FramingCandidate.class, (json, typeOfT, context) -> {
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Not an object: " + json);
        }
        JsonObject obj = json.getAsJsonObject();
        FrameableModel.FramingCandidate candidate = new FrameableModel.FramingCandidate();
        FrameableModel.FramingCandidate.Condition condition = (FrameableModel.FramingCandidate.Condition)context.deserialize(obj.get("condition"), FrameableModel.FramingCandidate.Condition.class);
        if (condition != null) {
            candidate.condition = condition;
        }
        candidate.face = (BlockElementFace)context.deserialize(json, BlockElementFace.class);
        candidate.direction = (Direction)context.deserialize(obj.get("face"), Direction.class);
        candidate.start = (Vector3f)context.deserialize(obj.get("start"), Vector3f.class);
        candidate.end = (Vector3f)context.deserialize(obj.get("end"), Vector3f.class);
        if (candidate.start.m_122239_() != candidate.end.m_122239_() && candidate.start.m_122260_() != candidate.end.m_122260_() && candidate.start.m_122269_() != candidate.end.m_122269_()) {
            throw new JsonSyntaxException(String.format("Start and end points %s and %s aren't aligned on any axis!", candidate.start, candidate.end));
        }
        return candidate;
    }).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();

    public void m_6213_(ResourceManager resourceManager) {
    }

    public FrameableModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        return (FrameableModel)gson.fromJson(modelContents.get("frameable"), FrameableModel.class);
    }

    private static /* synthetic */ Object lambda$static$0(JsonDeserializationContext context, Type valueType, JsonElement element) {
        return context.deserialize(element, valueType);
    }
}

