/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity;

public class ModEnchantTableRenderer
extends EnchantTableRenderer {
    public ModEnchantTableRenderer(BlockEntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void m_6922_(EnchantmentTableBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        super.m_6922_(tileEntityIn, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        ItemStack itemToEnchant = ((Container)tileEntityIn).m_8020_(0);
        ItemStack catalystItem = ((Container)tileEntityIn).m_8020_(1);
        int catalystCount = Math.min(catalystItem.m_41613_(), 3);
        int posData = (int)tileEntityIn.m_58899_().m_121878_();
        switch (((ClientConfig)EasyMagic.CONFIG.client()).renderContentsType) {
            case FLAT: {
                List<ItemStack> flatItems = this.getInventoryItemList(itemToEnchant, catalystItem, catalystCount);
                this.renderFlatItemList(flatItems, tileEntityIn.m_58899_(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, posData);
                break;
            }
            case FLOATING: {
                List<ItemStack> floatingItems = this.getInventoryItemList(itemToEnchant, catalystItem, catalystCount);
                this.renderHoveringItemList(floatingItems, (float)tileEntityIn.f_59251_ + partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, false, posData);
                break;
            }
            case FANCY_FLOATING: {
                List<ItemStack> fancyFloatingItems = this.getInventoryItemList(ItemStack.f_41583_, catalystItem, catalystCount);
                this.renderHoveringItem(itemToEnchant, tileEntityIn.m_58904_(), (float)tileEntityIn.f_59251_ + partialTicks, matrixStackIn, bufferIn, combinedLightIn);
                this.renderHoveringItemList(fancyFloatingItems, (float)tileEntityIn.f_59251_ + partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, true, posData);
            }
        }
    }

    private List<ItemStack> getInventoryItemList(ItemStack itemToEnchant, ItemStack catalystItem, int catalystCount) {
        ArrayList<ItemStack> inventoryItems = new ArrayList<ItemStack>(4);
        inventoryItems.add(itemToEnchant);
        for (int i = 0; i < catalystCount; ++i) {
            inventoryItems.add(catalystItem);
        }
        inventoryItems.removeIf(ItemStack::m_41619_);
        return inventoryItems;
    }

    private void renderFlatItemList(List<ItemStack> inventoryItems, BlockPos pos, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, int posData) {
        int randomDirection = Math.abs(pos.m_123341_() + pos.m_123343_()) % 4;
        for (int i = 0; i < inventoryItems.size(); ++i) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 0.76171875, 0.5);
            Direction direction = Direction.m_122407_((int)((i + randomDirection) % 4));
            float horizontalAngle = -direction.m_122435_();
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(horizontalAngle));
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            matrixStackIn.m_85837_(-0.3125, -0.3125, 0.0);
            matrixStackIn.m_85841_(0.375f, 0.375f, 0.375f);
            ItemStack renderStack = inventoryItems.get(i);
            Minecraft.m_91087_().m_91291_().m_174269_(renderStack, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, posData + i);
            matrixStackIn.m_85849_();
        }
    }

    private void renderHoveringItemList(List<ItemStack> inventoryItems, float age, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, boolean rotateItems, int posData) {
        float itemRenderAngle = 360.0f / (float)inventoryItems.size();
        for (int i = 0; i < inventoryItems.size(); ++i) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 1.0, 0.5);
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)i * itemRenderAngle + age));
            matrixStackIn.m_85837_(0.75, 0.0, 0.25);
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(rotateItems ? age % 360.0f : 90.0f));
            matrixStackIn.m_85837_(0.0, 0.075 * Math.sin(((double)age + (double)i * 10.0) / 5.0), 0.0);
            Minecraft.m_91087_().m_91291_().m_174269_(inventoryItems.get(i), ItemTransforms.TransformType.GROUND, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, posData + i);
            matrixStackIn.m_85849_();
        }
    }

    private void renderHoveringItem(ItemStack itemToEnchant, @Nullable Level worldIn, float age, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 1.0, 0.5);
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(itemToEnchant, worldIn, null, 0);
        float hoverOffset = Mth.m_14031_((float)(age / 10.0f)) * 0.1f + 0.1f;
        float modelYScale = model.m_7442_().m_111808_((ItemTransforms.TransformType)ItemTransforms.TransformType.GROUND).f_111757_.m_122260_();
        matrixStackIn.m_85837_(0.0, (double)(hoverOffset + 0.25f * modelYScale), 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122270_(age / 20.0f));
        Minecraft.m_91087_().m_91291_().m_115143_(itemToEnchant, ItemTransforms.TransformType.GROUND, false, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, model);
        matrixStackIn.m_85849_();
    }
}

