/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class ChippedRecipe
implements Recipe<Container> {
    public static final RecipeType<ChippedRecipe> BOTANIST_WORKBENCH_TYPE = RecipeType.m_44119_((String)"chipped:botanist_workbench");
    public static final RecipeType<ChippedRecipe> GLASSBLOWER_TYPE = RecipeType.m_44119_((String)"chipped:glassblower");
    public static final RecipeType<ChippedRecipe> CARPENTERS_TABLE_TYPE = RecipeType.m_44119_((String)"chipped:carpenters_table");
    public static final RecipeType<ChippedRecipe> LOOM_TABLE_TYPE = RecipeType.m_44119_((String)"chipped:loom_table");
    public static final RecipeType<ChippedRecipe> MASON_TABLE_TYPE = RecipeType.m_44119_((String)"chipped:mason_table");
    public static final RecipeType<ChippedRecipe> ALCHEMY_BENCH_TYPE = RecipeType.m_44119_((String)"chipped:alchemy_bench");
    public static final RecipeType<ChippedRecipe> MECHANIST_WORKBENCH_TYPE = RecipeType.m_44119_((String)"chipped:mechanist_workbench");
    private final Serializer serializer;
    private final ResourceLocation id;
    private final String group;
    private final List<HolderSet<Item>> tags;
    private final Block icon;

    public ChippedRecipe(Serializer serializer, ResourceLocation id, String group, List<HolderSet<Item>> tags, Block block) {
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.tags = tags;
        this.icon = block;
    }

    public boolean m_5818_(Container inventory, @NotNull Level world) {
        ItemStack item = inventory.m_8020_(0);
        return !item.m_41619_() && this.tags.stream().anyMatch(tag -> ChippedRecipe.tagIs(item, (HolderSet<Item>)tag));
    }

    private static boolean tagIs(ItemStack stack, HolderSet<Item> tag) {
        return tag.m_203333_((Holder)stack.m_41720_().m_204114_());
    }

    public List<HolderSet<Item>> getTags() {
        return this.tags;
    }

    public Stream<ItemStack> getResults(Container container) {
        ItemStack current = container.m_8020_(0);
        if (!current.m_41619_()) {
            Item item = current.m_41720_();
            return this.tags.stream().filter(tag -> ChippedRecipe.tagIs(current, (HolderSet<Item>)tag)).flatMap(tag -> tag.m_203614_().filter(Holder::m_203633_).map(Holder::m_203334_)).filter(value -> value != item).map(ItemStack::new);
        }
        return Stream.empty();
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container inventory) {
        return this.m_8043_();
    }

    public boolean m_8004_(int i, int j) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public boolean m_5598_() {
        return true;
    }

    @NotNull
    public String m_6076_() {
        return this.group;
    }

    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)this.icon);
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return this.serializer.getType();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ChippedRecipe> {
        private final RecipeType<?> type;
        private final Block icon;

        public Serializer(RecipeType<?> type, Block icon) {
            this.type = type;
            this.icon = icon;
        }

        @NotNull
        public ChippedRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            ArrayList<HolderSet<Item>> tags = new ArrayList<HolderSet<Item>>();
            JsonArray tagArray = GsonHelper.m_13933_((JsonObject)json, (String)"tags");
            for (int i = 0; i < tagArray.size(); ++i) {
                String tagName = GsonHelper.m_13805_((JsonElement)tagArray.get(i), (String)("tags[" + i + "]"));
                TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(tagName));
                tags.add((HolderSet<Item>)Registry.f_122827_.m_203561_(tag));
            }
            return new ChippedRecipe(this, recipeId, s, tags, this.icon);
        }

        public ChippedRecipe fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130136_(Short.MAX_VALUE);
            int tagCount = buffer.m_130242_();
            ArrayList<HolderSet<Item>> tags = new ArrayList<HolderSet<Item>>(tagCount);
            for (int i = 0; i < tagCount; ++i) {
                tags.add((HolderSet<Item>)HolderSet.m_205803_(Item::m_204114_, (List)buffer.m_178366_(buf -> Item.m_41445_((int)buf.m_130242_()))));
            }
            return new ChippedRecipe(this, recipeId, s, tags, this.icon);
        }

        public void toNetwork(FriendlyByteBuf buffer, @NotNull ChippedRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.tags.size());
            for (HolderSet<Item> tag : recipe.tags) {
                List<Item> items = tag.m_203614_().filter(Holder::m_203633_).map(Holder::m_203334_).toList();
                buffer.m_178352_(items, (buf, item) -> buf.m_130130_(Item.m_41393_((Item)item)));
            }
        }

        public RecipeType<?> getType() {
            return this.type;
        }
    }
}

