/*
 * Decompiled with CFR 0.152.
 */
package mca;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public final class Config
implements Serializable {
    private static final long serialVersionUID = 956221997003825933L;
    private static final Config INSTANCE = Config.loadOrCreate();
    public static final int VERSION = 1;
    public int version = 0;
    public boolean overwriteOriginalVillagers = true;
    public boolean overwriteOriginalZombieVillagers = true;
    public boolean villagerTagsHacks = true;
    public boolean enableInfection = true;
    public int infectionChance = 5;
    public boolean allowGrimReaper = true;
    public int guardSpawnRate = 6;
    public int chanceToHaveTwins = 2;
    public float marriageHeartsRequirement = 100.0f;
    public int babyGrowUpTime = 20;
    public int villagerMaxAgeTime = 192000;
    public int villagerMaxHealth = 20;
    public String villagerChatPrefix = "";
    public boolean allowPlayerMarriage = true;
    public boolean allowVillagerTeleporting = false;
    public double villagerTeleportLimit = 144.0;
    public int roseGoldSpawnWeight = 6;
    public boolean allowRoseGoldGeneration = true;
    public int marriageChance = 5;
    public int childrenChance = 5;
    public int giftDesaturationQueueLength = 16;
    public float giftDesaturationFactor = 0.5f;
    public double giftDesaturationExponent = 0.85;
    public double giftSatisfactionFactor = 0.33;
    public int baseGiftMoodEffect = 2;
    public int giftDesaturationReset = 24000;
    public int greetHeartsThreshold = 75;
    public int greetAfterDays = 1;
    public int childInitialHearts = 100;
    public int immigrantChance = 20;
    public int bountyHunterInterval = 24000;
    public int bountyHunterThreshold = -5;
    public float traitChance = 0.25f;
    public float traitInheritChance = 0.5f;
    public float villagerHeight = 0.9f;
    public boolean canHurtBabies = true;
    public boolean useVoices = false;
    public boolean useVanillaVoices = false;
    public int interactionChanceFatigue = 1;
    public int interactionFatigueCooldown = 4800;
    public float taxesFactor = 0.5f;
    public boolean enterVillageNotification = true;
    public boolean showNameTags = true;
    public int villagerHealthBonusPerLevel = 5;
    public boolean useSquidwardModels = false;
    public int maxBuildingSize = 8192;
    public int maxBuildingRadius = 320;
    public int maxTreeHeight = 8;
    public Map<String, Integer> maxTreeTicks = ImmutableMap.builder().put((Object)"#minecraft:logs", (Object)60).build();
    public List<String> validTreeSources = List.of("minecraft:grass_block", "minecraft:dirt");
    public int heartsForPardonHit = 30;
    public int pardonPlayerTicks = 1200;
    public boolean guardsTargetMonsters = false;
    public Map<String, Integer> guardsTargetEntities = ImmutableMap.builder().put((Object)"minecraft:creeper", (Object)-1).put((Object)"minecraft:drowned", (Object)2).put((Object)"minecraft:evoker", (Object)3).put((Object)"minecraft:husk", (Object)2).put((Object)"minecraft:illusioner", (Object)3).put((Object)"minecraft:pillager", (Object)3).put((Object)"minecraft:ravager", (Object)3).put((Object)"minecraft:vex", (Object)0).put((Object)"minecraft:vindicator", (Object)4).put((Object)"minecraft:zoglin", (Object)2).put((Object)"minecraft:zombie", (Object)4).put((Object)"minecraft:zombie_villager", (Object)3).put((Object)"minecraft:spider", (Object)0).put((Object)"minecraft:skeleton", (Object)0).put((Object)"minecraft:slime", (Object)0).put((Object)"mcafemale_zombie_villager", (Object)3).put((Object)"mcamale_zombie_villager", (Object)3).build();
    public List<String> villagerPathfindingBlacklist = List.of("#minecraft:climbable", "#minecraft:fence_gates", "#minecraft:fences", "#minecraft:fire", "#minecraft:portals", "#minecraft:slabs", "#minecraft:stairs", "#minecraft:trapdoors", "#minecraft:walls");

    public static Config getInstance() {
        return INSTANCE;
    }

    public static File getConfigFile() {
        return new File("./config/mca.json");
    }

    public void save() {
        try (FileWriter writer = new FileWriter(Config.getConfigFile());){
            this.version = 1;
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Config loadOrCreate() {
        Config config;
        FileReader reader2 = new FileReader(Config.getConfigFile());
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Config config2 = (Config)gson.fromJson((Reader)reader2, Config.class);
            if (config2.version != 1) {
                config2 = new Config();
            }
            config2.save();
            config = config2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException reader2) {
                Config config3 = new Config();
                config3.save();
                return config3;
            }
        }
        reader2.close();
        return config;
    }
}

