/*
 * Decompiled with CFR 0.152.
 */
package mca.client.book.pages;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mca.client.book.pages.Page;
import mca.client.gui.ExtendedBookScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;

public class TitlePage
extends Page {
    final Component title;
    final Component subtitle;

    public TitlePage(String book) {
        this(book, ChatFormatting.BLACK);
    }

    public TitlePage(String book, ChatFormatting color) {
        this("item.mca.book_" + book, "mca.books." + book + ".author", color);
    }

    public TitlePage(String title, String subtitle) {
        this(title, subtitle, ChatFormatting.BLACK);
    }

    public TitlePage(String title, String subtitle, ChatFormatting color) {
        this((Component)new TranslatableComponent(title).m_130940_(color).m_130940_(ChatFormatting.BOLD), (Component)new TranslatableComponent(subtitle).m_130940_(color).m_130940_(ChatFormatting.ITALIC));
    }

    public TitlePage(Component title, Component subtitle) {
        this.title = title;
        this.subtitle = subtitle;
    }

    private static void drawCenteredText(PoseStack matrices, Font textRenderer, Component text, int centerX, int y, int color) {
        FormattedCharSequence orderedText = text.m_7532_();
        TitlePage.drawCenteredText(matrices, textRenderer, orderedText, centerX, y, color);
    }

    private static void drawCenteredText(PoseStack matrices, Font textRenderer, FormattedCharSequence text, int centerX, int y, int color) {
        textRenderer.m_92877_(matrices, text, (float)(centerX - textRenderer.m_92724_(text) / 2), (float)y, color);
    }

    @Override
    public void render(ExtendedBookScreen screen, PoseStack matrices, int mouseX, int mouseY, float delta) {
        List texts = screen.getTextRenderer().m_92923_((FormattedText)this.title, 114);
        int y = 80 - 5 * texts.size();
        for (FormattedCharSequence t : texts) {
            TitlePage.drawCenteredText(matrices, screen.getTextRenderer(), t, screen.f_96543_ / 2 - 2, y, 0xFFFFFF);
            y += 10;
        }
        y = 82 + 5 * texts.size();
        TitlePage.drawCenteredText(matrices, screen.getTextRenderer(), this.subtitle, screen.f_96543_ / 2 - 2, y, 0xFFFFFF);
    }
}

